/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;
import software.amazon.awssdk.services.kinesis.model.EnhancedMonitoringListCopier;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;
import software.amazon.awssdk.services.kinesis.transform.StreamDescriptionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamDescriptionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamDescriptionSummary> {
    private final String streamName;
    private final String streamARN;
    private final String streamStatus;
    private final Integer retentionPeriodHours;
    private final Instant streamCreationTimestamp;
    private final List<EnhancedMetrics> enhancedMonitoring;
    private final String encryptionType;
    private final String keyId;
    private final Integer openShardCount;

    private StreamDescriptionSummary(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
        this.openShardCount = builder.openShardCount;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public String streamStatusAsString() {
        return this.streamStatus;
    }

    public Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public List<EnhancedMetrics> enhancedMonitoring() {
        return this.enhancedMonitoring;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public String keyId() {
        return this.keyId;
    }

    public Integer openShardCount() {
        return this.openShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.openShardCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescriptionSummary)) {
            return false;
        }
        StreamDescriptionSummary other = (StreamDescriptionSummary)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp()) && Objects.equals(this.enhancedMonitoring(), other.enhancedMonitoring()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.openShardCount(), other.openShardCount());
    }

    public String toString() {
        return ToString.builder((String)"StreamDescriptionSummary").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("StreamStatus", (Object)this.streamStatusAsString()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).add("StreamCreationTimestamp", (Object)this.streamCreationTimestamp()).add("EnhancedMonitoring", this.enhancedMonitoring()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KeyId", (Object)this.keyId()).add("OpenShardCount", (Object)this.openShardCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "RetentionPeriodHours": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodHours()));
            }
            case "StreamCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.streamCreationTimestamp()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoring()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "OpenShardCount": {
                return Optional.ofNullable(clazz.cast(this.openShardCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String streamStatus;
        private Integer retentionPeriodHours;
        private Instant streamCreationTimestamp;
        private List<EnhancedMetrics> enhancedMonitoring = DefaultSdkAutoConstructList.getInstance();
        private String encryptionType;
        private String keyId;
        private Integer openShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescriptionSummary model) {
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.streamStatus(model.streamStatus);
            this.retentionPeriodHours(model.retentionPeriodHours);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
            this.openShardCount(model.openShardCount);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        public final Collection<EnhancedMetrics.Builder> getEnhancedMonitoring() {
            return this.enhancedMonitoring != null ? (Collection)this.enhancedMonitoring.stream().map(EnhancedMetrics::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
            this.enhancedMonitoring(Arrays.asList(enhancedMonitoring));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... enhancedMonitoring) {
            this.enhancedMonitoring(Stream.of(enhancedMonitoring).map(c -> (EnhancedMetrics)((EnhancedMetrics.Builder)EnhancedMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnhancedMonitoring(Collection<EnhancedMetrics.BuilderImpl> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copyFromBuilder(enhancedMonitoring);
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Integer getOpenShardCount() {
            return this.openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        public StreamDescriptionSummary build() {
            return new StreamDescriptionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamDescriptionSummary> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder enhancedMonitoring(Collection<EnhancedMetrics> var1);

        public Builder enhancedMonitoring(EnhancedMetrics ... var1);

        public Builder enhancedMonitoring(Consumer<EnhancedMetrics.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);

        public Builder openShardCount(Integer var1);
    }
}

