/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link OutputDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OutputDescriptionMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsOutputDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseOutputDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DestinationSchema").isBinary(false).build();

    private static final OutputDescriptionMarshaller INSTANCE = new OutputDescriptionMarshaller();

    private OutputDescriptionMarshaller() {
    }

    public static OutputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(OutputDescription outputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(outputDescription, "outputDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(outputDescription.outputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall(outputDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall(outputDescription.kinesisStreamsOutputDescription(),
                    KINESISSTREAMSOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(outputDescription.kinesisFirehoseOutputDescription(),
                    KINESISFIREHOSEOUTPUTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(outputDescription.destinationSchema(), DESTINATIONSCHEMA_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
