/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InputSchemaUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InputSchemaUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMATUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RecordFormatUpdate").isBinary(false).build();

    private static final MarshallingInfo<String> RECORDENCODINGUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncodingUpdate").isBinary(false).build();

    private static final MarshallingInfo<List> RECORDCOLUMNUPDATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumnUpdates").isBinary(false).build();

    private static final InputSchemaUpdateMarshaller INSTANCE = new InputSchemaUpdateMarshaller();

    private InputSchemaUpdateMarshaller() {
    }

    public static InputSchemaUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InputSchemaUpdate inputSchemaUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(inputSchemaUpdate, "inputSchemaUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(inputSchemaUpdate.recordFormatUpdate(), RECORDFORMATUPDATE_BINDING);
            protocolMarshaller.marshall(inputSchemaUpdate.recordEncodingUpdate(), RECORDENCODINGUPDATE_BINDING);
            protocolMarshaller.marshall(inputSchemaUpdate.recordColumnUpdates(), RECORDCOLUMNUPDATES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
