/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Configuration implements StructuredPojo, ToCopyableBuilder<S3Configuration.Builder, S3Configuration> {
    private final String roleARN;

    private final String bucketARN;

    private final String fileKey;

    private S3Configuration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
    }

    /**
     * Returns the value of the RoleARN property for this object.
     * 
     * @return The value of the RoleARN property for this object.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * Returns the value of the BucketARN property for this object.
     * 
     * @return The value of the BucketARN property for this object.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * Returns the value of the FileKey property for this object.
     * 
     * @return The value of the FileKey property for this object.
     */
    public String fileKey() {
        return fileKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Configuration)) {
            return false;
        }
        S3Configuration other = (S3Configuration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(bucketARN(), other.bucketARN())
                && Objects.equals(fileKey(), other.fileKey());
    }

    @Override
    public String toString() {
        return ToString.builder("S3Configuration").add("RoleARN", roleARN()).add("BucketARN", bucketARN())
                .add("FileKey", fileKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "BucketARN":
            return Optional.of(clazz.cast(bucketARN()));
        case "FileKey":
            return Optional.of(clazz.cast(fileKey()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3Configuration> {
        /**
         * Sets the value of the RoleARN property for this object.
         *
         * @param roleARN
         *        The new value for the RoleARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * Sets the value of the BucketARN property for this object.
         *
         * @param bucketARN
         *        The new value for the BucketARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * Sets the value of the FileKey property for this object.
         *
         * @param fileKey
         *        The new value for the FileKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String bucketARN;

        private String fileKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Configuration model) {
            roleARN(model.roleARN);
            bucketARN(model.bucketARN);
            fileKey(model.fileKey);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public S3Configuration build() {
            return new S3Configuration(this);
        }
    }
}
