/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputStartingPositionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the point at which the application reads from the streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputStartingPositionConfiguration implements StructuredPojo,
        ToCopyableBuilder<InputStartingPositionConfiguration.Builder, InputStartingPositionConfiguration> {
    private final String inputStartingPosition;

    private InputStartingPositionConfiguration(BuilderImpl builder) {
        this.inputStartingPosition = builder.inputStartingPosition;
    }

    /**
     * <p>
     * The starting position on the stream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request timestamp
     * that the customer issued.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest record
     * available in the stream. This option is not available for an Amazon Kinesis Firehose delivery stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputStartingPosition} will return {@link InputStartingPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputStartingPositionAsString}.
     * </p>
     * 
     * @return The starting position on the stream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
     *         timestamp that the customer issued.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
     *         record available in the stream. This option is not available for an Amazon Kinesis Firehose delivery
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     *         </p>
     *         </li>
     * @see InputStartingPosition
     */
    public InputStartingPosition inputStartingPosition() {
        return InputStartingPosition.fromValue(inputStartingPosition);
    }

    /**
     * <p>
     * The starting position on the stream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request timestamp
     * that the customer issued.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest record
     * available in the stream. This option is not available for an Amazon Kinesis Firehose delivery stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputStartingPosition} will return {@link InputStartingPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputStartingPositionAsString}.
     * </p>
     * 
     * @return The starting position on the stream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
     *         timestamp that the customer issued.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
     *         record available in the stream. This option is not available for an Amazon Kinesis Firehose delivery
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     *         </p>
     *         </li>
     * @see InputStartingPosition
     */
    public String inputStartingPositionAsString() {
        return inputStartingPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputStartingPositionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputStartingPositionConfiguration)) {
            return false;
        }
        InputStartingPositionConfiguration other = (InputStartingPositionConfiguration) obj;
        return Objects.equals(inputStartingPositionAsString(), other.inputStartingPositionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InputStartingPositionConfiguration")
                .add("InputStartingPosition", inputStartingPositionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputStartingPosition":
            return Optional.of(clazz.cast(inputStartingPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputStartingPositionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputStartingPositionConfiguration> {
        /**
         * <p>
         * The starting position on the stream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
         * timestamp that the customer issued.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
         * record available in the stream. This option is not available for an Amazon Kinesis Firehose delivery stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputStartingPosition
         *        The starting position on the stream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
         *        timestamp that the customer issued.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the
         *        oldest record available in the stream. This option is not available for an Amazon Kinesis Firehose
         *        delivery stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         *        </p>
         *        </li>
         * @see InputStartingPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStartingPosition
         */
        Builder inputStartingPosition(String inputStartingPosition);

        /**
         * <p>
         * The starting position on the stream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
         * timestamp that the customer issued.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
         * record available in the stream. This option is not available for an Amazon Kinesis Firehose delivery stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputStartingPosition
         *        The starting position on the stream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Start reading just after the most recent record in the stream, start at the request
         *        timestamp that the customer issued.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the
         *        oldest record available in the stream. This option is not available for an Amazon Kinesis Firehose
         *        delivery stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         *        </p>
         *        </li>
         * @see InputStartingPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStartingPosition
         */
        Builder inputStartingPosition(InputStartingPosition inputStartingPosition);
    }

    static final class BuilderImpl implements Builder {
        private String inputStartingPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(InputStartingPositionConfiguration model) {
            inputStartingPosition(model.inputStartingPosition);
        }

        public final String getInputStartingPosition() {
            return inputStartingPosition;
        }

        @Override
        public final Builder inputStartingPosition(String inputStartingPosition) {
            this.inputStartingPosition = inputStartingPosition;
            return this;
        }

        @Override
        public final Builder inputStartingPosition(InputStartingPosition inputStartingPosition) {
            this.inputStartingPosition(inputStartingPosition.toString());
            return this;
        }

        public final void setInputStartingPosition(String inputStartingPosition) {
            this.inputStartingPosition = inputStartingPosition;
        }

        @Override
        public InputStartingPositionConfiguration build() {
            return new InputStartingPositionConfiguration(this);
        }
    }
}
