/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputSchemaUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates for the application's input schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputSchemaUpdate implements StructuredPojo, ToCopyableBuilder<InputSchemaUpdate.Builder, InputSchemaUpdate> {
    private final RecordFormat recordFormatUpdate;

    private final String recordEncodingUpdate;

    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    /**
     * <p>
     * Specifies the format of the records on the streaming source.
     * </p>
     * 
     * @return Specifies the format of the records on the streaming source.
     */
    public RecordFormat recordFormatUpdate() {
        return recordFormatUpdate;
    }

    /**
     * <p>
     * Specifies the encoding of the records in the streaming source. For example, UTF-8.
     * </p>
     * 
     * @return Specifies the encoding of the records in the streaming source. For example, UTF-8.
     */
    public String recordEncodingUpdate() {
        return recordEncodingUpdate;
    }

    /**
     * <p>
     * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source element to
     * the corresponding column in the in-application stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
     *         element to the corresponding column in the in-application stream.
     */
    public List<RecordColumn> recordColumnUpdates() {
        return recordColumnUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(recordEncodingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(recordColumnUpdates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate) obj;
        return Objects.equals(recordFormatUpdate(), other.recordFormatUpdate())
                && Objects.equals(recordEncodingUpdate(), other.recordEncodingUpdate())
                && Objects.equals(recordColumnUpdates(), other.recordColumnUpdates());
    }

    @Override
    public String toString() {
        return ToString.builder("InputSchemaUpdate").add("RecordFormatUpdate", recordFormatUpdate())
                .add("RecordEncodingUpdate", recordEncodingUpdate()).add("RecordColumnUpdates", recordColumnUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatUpdate":
            return Optional.of(clazz.cast(recordFormatUpdate()));
        case "RecordEncodingUpdate":
            return Optional.of(clazz.cast(recordEncodingUpdate()));
        case "RecordColumnUpdates":
            return Optional.of(clazz.cast(recordColumnUpdates()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSchemaUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputSchemaUpdate> {
        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * 
         * @param recordFormatUpdate
         *        Specifies the format of the records on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFormatUpdate(RecordFormat recordFormatUpdate);

        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * This is a convenience that creates an instance of the {@link RecordFormat.Builder} avoiding the need to
         * create one manually via {@link RecordFormat#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecordFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #recordFormatUpdate(RecordFormat)}.
         * 
         * @param recordFormatUpdate
         *        a consumer that will call methods on {@link RecordFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordFormatUpdate(RecordFormat)
         */
        default Builder recordFormatUpdate(Consumer<RecordFormat.Builder> recordFormatUpdate) {
            return recordFormatUpdate(RecordFormat.builder().apply(recordFormatUpdate).build());
        }

        /**
         * <p>
         * Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * </p>
         * 
         * @param recordEncodingUpdate
         *        Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordEncodingUpdate(String recordEncodingUpdate);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(RecordColumn... recordColumnUpdates);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecordColumn>.Builder} avoiding the need to
         * create one manually via {@link List<RecordColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecordColumn>.Builder#build()} is called immediately and its
         * result is passed to {@link #recordColumnUpdates(List<RecordColumn>)}.
         * 
         * @param recordColumnUpdates
         *        a consumer that will call methods on {@link List<RecordColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordColumnUpdates(List<RecordColumn>)
         */
        Builder recordColumnUpdates(Consumer<RecordColumn.Builder>... recordColumnUpdates);
    }

    static final class BuilderImpl implements Builder {
        private RecordFormat recordFormatUpdate;

        private String recordEncodingUpdate;

        private List<RecordColumn> recordColumnUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            recordFormatUpdate(model.recordFormatUpdate);
            recordEncodingUpdate(model.recordEncodingUpdate);
            recordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat.Builder getRecordFormatUpdate() {
            return recordFormatUpdate != null ? recordFormatUpdate.toBuilder() : null;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final void setRecordFormatUpdate(RecordFormat.BuilderImpl recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate != null ? recordFormatUpdate.build() : null;
        }

        public final String getRecordEncodingUpdate() {
            return recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        public final Collection<RecordColumn.Builder> getRecordColumnUpdates() {
            return recordColumnUpdates != null ? recordColumnUpdates.stream().map(RecordColumn::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn... recordColumnUpdates) {
            recordColumnUpdates(Arrays.asList(recordColumnUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(Consumer<RecordColumn.Builder>... recordColumnUpdates) {
            recordColumnUpdates(Stream.of(recordColumnUpdates).map(c -> RecordColumn.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn.BuilderImpl> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copyFromBuilder(recordColumnUpdates);
        }

        @Override
        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }
    }
}
