/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationInputProcessingConfigurationRequest extends KinesisAnalyticsRequest
        implements
        ToCopyableBuilder<AddApplicationInputProcessingConfigurationRequest.Builder, AddApplicationInputProcessingConfigurationRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String inputId;

    private final InputProcessingConfiguration inputProcessingConfiguration;

    private AddApplicationInputProcessingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.inputId = builder.inputId;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    /**
     * <p>
     * Name of the application to which you want to add the input processing configuration.
     * </p>
     * 
     * @return Name of the application to which you want to add the input processing configuration.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application to which you want to add the input processing configuration. You can use the
     * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Version of the application to which you want to add the input processing configuration. You can use the
     *         <a>DescribeApplication</a> operation to get the current application version. If the version specified is
     *         not the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the input configuration to which to add the input configuration. You can get a list of the input IDs
     * for an application using the <a>DescribeApplication</a> operation.
     * </p>
     * 
     * @return The ID of the input configuration to which to add the input configuration. You can get a list of the
     *         input IDs for an application using the <a>DescribeApplication</a> operation.
     */
    public String inputId() {
        return inputId;
    }

    /**
     * <p>
     * The <a>InputProcessingConfiguration</a> to add to the application.
     * </p>
     * 
     * @return The <a>InputProcessingConfiguration</a> to add to the application.
     */
    public InputProcessingConfiguration inputProcessingConfiguration() {
        return inputProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputProcessingConfigurationRequest)) {
            return false;
        }
        AddApplicationInputProcessingConfigurationRequest other = (AddApplicationInputProcessingConfigurationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(inputId(), other.inputId())
                && Objects.equals(inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("AddApplicationInputProcessingConfigurationRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId()).add("InputId", inputId())
                .add("InputProcessingConfiguration", inputProcessingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "InputId":
            return Optional.of(clazz.cast(inputId()));
        case "InputProcessingConfiguration":
            return Optional.of(clazz.cast(inputProcessingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder,
            CopyableBuilder<Builder, AddApplicationInputProcessingConfigurationRequest> {
        /**
         * <p>
         * Name of the application to which you want to add the input processing configuration.
         * </p>
         * 
         * @param applicationName
         *        Name of the application to which you want to add the input processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application to which you want to add the input processing configuration. You can use the
         * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not
         * the current version, the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application to which you want to add the input processing configuration. You can use
         *        the <a>DescribeApplication</a> operation to get the current application version. If the version
         *        specified is not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the input configuration to which to add the input configuration. You can get a list of the input
         * IDs for an application using the <a>DescribeApplication</a> operation.
         * </p>
         * 
         * @param inputId
         *        The ID of the input configuration to which to add the input configuration. You can get a list of the
         *        input IDs for an application using the <a>DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> to add to the application.
         * </p>
         * 
         * @param inputProcessingConfiguration
         *        The <a>InputProcessingConfiguration</a> to add to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration);

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> to add to the application.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link InputProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inputProcessingConfiguration(InputProcessingConfiguration)}.
         * 
         * @param inputProcessingConfiguration
         *        a consumer that will call methods on {@link InputProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfiguration(InputProcessingConfiguration)
         */
        default Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return inputProcessingConfiguration(InputProcessingConfiguration.builder().apply(inputProcessingConfiguration)
                    .build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String inputId;

        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputProcessingConfigurationRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            inputId(model.inputId);
            inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return inputProcessingConfiguration != null ? inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build()
                    : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationInputProcessingConfigurationRequest build() {
            return new AddApplicationInputProcessingConfigurationRequest(this);
        }
    }
}
