/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationCloudWatchLoggingOptionRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<AddApplicationCloudWatchLoggingOptionRequest.Builder, AddApplicationCloudWatchLoggingOptionRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final CloudWatchLoggingOption cloudWatchLoggingOption;

    private AddApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOption = builder.cloudWatchLoggingOption;
    }

    /**
     * <p>
     * The Kinesis Analytics application name.
     * </p>
     * 
     * @return The Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Kinesis Analytics application.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application
     * messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
     *         application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code>
     *         policy action enabled.
     */
    public CloudWatchLoggingOption cloudWatchLoggingOption() {
        return cloudWatchLoggingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionRequest other = (AddApplicationCloudWatchLoggingOptionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(cloudWatchLoggingOption(), other.cloudWatchLoggingOption());
    }

    @Override
    public String toString() {
        return ToString.builder("AddApplicationCloudWatchLoggingOptionRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("CloudWatchLoggingOption", cloudWatchLoggingOption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "CloudWatchLoggingOption":
            return Optional.of(clazz.cast(cloudWatchLoggingOption()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder,
            CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionRequest> {
        /**
         * <p>
         * The Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         * application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy
         * action enabled.
         * </p>
         * 
         * @param cloudWatchLoggingOption
         *        Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         *        application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code>
         *        policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption);

        /**
         * <p>
         * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         * application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy
         * action enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOption.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOption.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOption(CloudWatchLoggingOption)}.
         * 
         * @param cloudWatchLoggingOption
         *        a consumer that will call methods on {@link CloudWatchLoggingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOption(CloudWatchLoggingOption)
         */
        default Builder cloudWatchLoggingOption(Consumer<CloudWatchLoggingOption.Builder> cloudWatchLoggingOption) {
            return cloudWatchLoggingOption(CloudWatchLoggingOption.builder().apply(cloudWatchLoggingOption).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private CloudWatchLoggingOption cloudWatchLoggingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            cloudWatchLoggingOption(model.cloudWatchLoggingOption);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final CloudWatchLoggingOption.Builder getCloudWatchLoggingOption() {
            return cloudWatchLoggingOption != null ? cloudWatchLoggingOption.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        public final void setCloudWatchLoggingOption(CloudWatchLoggingOption.BuilderImpl cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption != null ? cloudWatchLoggingOption.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationCloudWatchLoggingOptionRequest build() {
            return new AddApplicationCloudWatchLoggingOptionRequest(this);
        }
    }
}
