/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SplunkDestinationDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SplunkDestinationDescriptionMarshaller {
    private static final MarshallingInfo<String> HECENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpoint").isBinary(false).build();

    private static final MarshallingInfo<String> HECENDPOINTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECEndpointType").isBinary(false).build();

    private static final MarshallingInfo<String> HECTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HECToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("HECAcknowledgmentTimeoutInSeconds").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions")
            .isBinary(false).build();

    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3DestinationDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProcessingConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();

    private static final SplunkDestinationDescriptionMarshaller INSTANCE = new SplunkDestinationDescriptionMarshaller();

    private SplunkDestinationDescriptionMarshaller() {
    }

    public static SplunkDestinationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SplunkDestinationDescription splunkDestinationDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(splunkDestinationDescription, "splunkDestinationDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(splunkDestinationDescription.hecEndpoint(), HECENDPOINT_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.hecEndpointTypeAsString(), HECENDPOINTTYPE_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.hecToken(), HECTOKEN_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.hecAcknowledgmentTimeoutInSeconds(),
                    HECACKNOWLEDGMENTTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.s3BackupModeAsString(), S3BACKUPMODE_BINDING);
            protocolMarshaller
                    .marshall(splunkDestinationDescription.s3DestinationDescription(), S3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(splunkDestinationDescription.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller
                    .marshall(splunkDestinationDescription.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
