/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link KinesisStreamSourceDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class KinesisStreamSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> KINESISSTREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamARN").isBinary(false).build();

    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<Instant> DELIVERYSTARTTIMESTAMP_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeliveryStartTimestamp").isBinary(false).build();

    private static final KinesisStreamSourceDescriptionMarshaller INSTANCE = new KinesisStreamSourceDescriptionMarshaller();

    private KinesisStreamSourceDescriptionMarshaller() {
    }

    public static KinesisStreamSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(KinesisStreamSourceDescription kinesisStreamSourceDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(kinesisStreamSourceDescription, "kinesisStreamSourceDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(kinesisStreamSourceDescription.kinesisStreamARN(), KINESISSTREAMARN_BINDING);
            protocolMarshaller.marshall(kinesisStreamSourceDescription.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(kinesisStreamSourceDescription.deliveryStartTimestamp(), DELIVERYSTARTTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
