/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateDeliveryStreamRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateDeliveryStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").isBinary(false).build();

    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCECONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamSourceConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3DestinationConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExtendedS3DestinationConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RedshiftDestinationConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ElasticsearchDestinationConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SplunkDestinationConfiguration").isBinary(false).build();

    private static final CreateDeliveryStreamRequestModelMarshaller INSTANCE = new CreateDeliveryStreamRequestModelMarshaller();

    private CreateDeliveryStreamRequestModelMarshaller() {
    }

    public static CreateDeliveryStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createDeliveryStreamRequest, "createDeliveryStreamRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createDeliveryStreamRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.deliveryStreamTypeAsString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.kinesisStreamSourceConfiguration(),
                    KINESISSTREAMSOURCECONFIGURATION_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.s3DestinationConfiguration(),
                    S3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.extendedS3DestinationConfiguration(),
                    EXTENDEDS3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.redshiftDestinationConfiguration(),
                    REDSHIFTDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.elasticsearchDestinationConfiguration(),
                    ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createDeliveryStreamRequest.splunkDestinationConfiguration(),
                    SPLUNKDESTINATIONCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
