/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.SourceDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis stream used as the source for a Kinesis Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SourceDescription implements StructuredPojo, ToCopyableBuilder<SourceDescription.Builder, SourceDescription> {
    private final KinesisStreamSourceDescription kinesisStreamSourceDescription;

    private SourceDescription(BuilderImpl builder) {
        this.kinesisStreamSourceDescription = builder.kinesisStreamSourceDescription;
    }

    /**
     * <p>
     * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis stream.
     * </p>
     * 
     * @return The <a>KinesisStreamSourceDescription</a> value for the source Kinesis stream.
     */
    public KinesisStreamSourceDescription kinesisStreamSourceDescription() {
        return kinesisStreamSourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDescription)) {
            return false;
        }
        SourceDescription other = (SourceDescription) obj;
        return Objects.equals(kinesisStreamSourceDescription(), other.kinesisStreamSourceDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("SourceDescription").add("KinesisStreamSourceDescription", kinesisStreamSourceDescription())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamSourceDescription":
            return Optional.of(clazz.cast(kinesisStreamSourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SourceDescription> {
        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamSourceDescription
         *        The <a>KinesisStreamSourceDescription</a> value for the source Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription);

        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamSourceDescription.Builder} avoiding
         * the need to create one manually via {@link KinesisStreamSourceDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamSourceDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceDescription(KinesisStreamSourceDescription)}.
         * 
         * @param kinesisStreamSourceDescription
         *        a consumer that will call methods on {@link KinesisStreamSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceDescription(KinesisStreamSourceDescription)
         */
        default Builder kinesisStreamSourceDescription(
                Consumer<KinesisStreamSourceDescription.Builder> kinesisStreamSourceDescription) {
            return kinesisStreamSourceDescription(KinesisStreamSourceDescription.builder().apply(kinesisStreamSourceDescription)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisStreamSourceDescription kinesisStreamSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDescription model) {
            kinesisStreamSourceDescription(model.kinesisStreamSourceDescription);
        }

        public final KinesisStreamSourceDescription.Builder getKinesisStreamSourceDescription() {
            return kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription;
            return this;
        }

        public final void setKinesisStreamSourceDescription(
                KinesisStreamSourceDescription.BuilderImpl kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.build()
                    : null;
        }

        @Override
        public SourceDescription build() {
            return new SourceDescription(this);
        }
    }
}
