/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.RedshiftRetryOptionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftRetryOptions implements StructuredPojo,
        ToCopyableBuilder<RedshiftRetryOptions.Builder, RedshiftRetryOptions> {
    private final Integer durationInSeconds;

    private RedshiftRetryOptions(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * The length of time during which Kinesis Firehose retries delivery after a failure, starting from the initial
     * request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Firehose does
     * not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes
     * longer than the current value.
     * </p>
     * 
     * @return The length of time during which Kinesis Firehose retries delivery after a failure, starting from the
     *         initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis
     *         Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first
     *         delivery attempt takes longer than the current value.
     */
    public Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftRetryOptions)) {
            return false;
        }
        RedshiftRetryOptions other = (RedshiftRetryOptions) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("RedshiftRetryOptions").add("DurationInSeconds", durationInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.of(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftRetryOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftRetryOptions> {
        /**
         * <p>
         * The length of time during which Kinesis Firehose retries delivery after a failure, starting from the initial
         * request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Firehose
         * does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt
         * takes longer than the current value.
         * </p>
         * 
         * @param durationInSeconds
         *        The length of time during which Kinesis Firehose retries delivery after a failure, starting from the
         *        initial request and including the first attempt. The default value is 3600 seconds (60 minutes).
         *        Kinesis Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the
         *        first delivery attempt takes longer than the current value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftRetryOptions model) {
            durationInSeconds(model.durationInSeconds);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public RedshiftRetryOptions build() {
            return new RedshiftRetryOptions(this);
        }
    }
}
