/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeliveryStreamsResponse extends FirehoseResponse implements
        ToCopyableBuilder<ListDeliveryStreamsResponse.Builder, ListDeliveryStreamsResponse> {
    private final List<String> deliveryStreamNames;

    private final Boolean hasMoreDeliveryStreams;

    private ListDeliveryStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamNames = builder.deliveryStreamNames;
        this.hasMoreDeliveryStreams = builder.hasMoreDeliveryStreams;
    }

    /**
     * <p>
     * The names of the delivery streams.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the delivery streams.
     */
    public List<String> deliveryStreamNames() {
        return deliveryStreamNames;
    }

    /**
     * <p>
     * Indicates whether there are more delivery streams available to list.
     * </p>
     * 
     * @return Indicates whether there are more delivery streams available to list.
     */
    public Boolean hasMoreDeliveryStreams() {
        return hasMoreDeliveryStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreDeliveryStreams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsResponse)) {
            return false;
        }
        ListDeliveryStreamsResponse other = (ListDeliveryStreamsResponse) obj;
        return Objects.equals(deliveryStreamNames(), other.deliveryStreamNames())
                && Objects.equals(hasMoreDeliveryStreams(), other.hasMoreDeliveryStreams());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDeliveryStreamsResponse").add("DeliveryStreamNames", deliveryStreamNames())
                .add("HasMoreDeliveryStreams", hasMoreDeliveryStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamNames":
            return Optional.of(clazz.cast(deliveryStreamNames()));
        case "HasMoreDeliveryStreams":
            return Optional.of(clazz.cast(hasMoreDeliveryStreams()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseResponse.Builder, CopyableBuilder<Builder, ListDeliveryStreamsResponse> {
        /**
         * <p>
         * The names of the delivery streams.
         * </p>
         * 
         * @param deliveryStreamNames
         *        The names of the delivery streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamNames(Collection<String> deliveryStreamNames);

        /**
         * <p>
         * The names of the delivery streams.
         * </p>
         * 
         * @param deliveryStreamNames
         *        The names of the delivery streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamNames(String... deliveryStreamNames);

        /**
         * <p>
         * Indicates whether there are more delivery streams available to list.
         * </p>
         * 
         * @param hasMoreDeliveryStreams
         *        Indicates whether there are more delivery streams available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private List<String> deliveryStreamNames;

        private Boolean hasMoreDeliveryStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsResponse model) {
            super(model);
            deliveryStreamNames(model.deliveryStreamNames);
            hasMoreDeliveryStreams(model.hasMoreDeliveryStreams);
        }

        public final Collection<String> getDeliveryStreamNames() {
            return deliveryStreamNames;
        }

        @Override
        public final Builder deliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryStreamNames(String... deliveryStreamNames) {
            deliveryStreamNames(Arrays.asList(deliveryStreamNames));
            return this;
        }

        public final void setDeliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
        }

        public final Boolean getHasMoreDeliveryStreams() {
            return hasMoreDeliveryStreams;
        }

        @Override
        public final Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
            return this;
        }

        public final void setHasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
        }

        @Override
        public ListDeliveryStreamsResponse build() {
            return new ListDeliveryStreamsResponse(this);
        }
    }
}
