/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputParallelismUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisFirehoseInputUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsInputUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaUnmarshaller;

public class InputUnmarshaller
implements Unmarshaller<Input, JsonUnmarshallerContext> {
    private static InputUnmarshaller INSTANCE;

    public Input unmarshall(JsonUnmarshallerContext context) throws Exception {
        Input.Builder inputBuilder = Input.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NamePrefix", targetDepth)) {
                    context.nextToken();
                    inputBuilder.namePrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KinesisStreamsInput", targetDepth)) {
                    context.nextToken();
                    inputBuilder.kinesisStreamsInput(KinesisStreamsInputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseInput", targetDepth)) {
                    context.nextToken();
                    inputBuilder.kinesisFirehoseInput(KinesisFirehoseInputUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputParallelism", targetDepth)) {
                    context.nextToken();
                    inputBuilder.inputParallelism(InputParallelismUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputSchema", targetDepth)) {
                    context.nextToken();
                    inputBuilder.inputSchema(SourceSchemaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Input)inputBuilder.build();
    }

    public static InputUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InputUnmarshaller();
        }
        return INSTANCE;
    }
}

