/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail;

@SdkInternalApi
public class ApplicationDetailMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").build();
    private static final MarshallingInfo<String> APPLICATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationDescription").build();
    private static final MarshallingInfo<String> APPLICATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationARN").build();
    private static final MarshallingInfo<String> APPLICATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationStatus").build();
    private static final MarshallingInfo<Date> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").build();
    private static final MarshallingInfo<List> INPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDescriptions").build();
    private static final MarshallingInfo<List> OUTPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDescriptions").build();
    private static final MarshallingInfo<List> REFERENCEDATASOURCEDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceDataSourceDescriptions").build();
    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptionDescriptions").build();
    private static final MarshallingInfo<String> APPLICATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCode").build();
    private static final MarshallingInfo<Long> APPLICATIONVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationVersionId").build();
    private static final ApplicationDetailMarshaller instance = new ApplicationDetailMarshaller();

    public static ApplicationDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApplicationDetail applicationDetail, ProtocolMarshaller protocolMarshaller) {
        if (applicationDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)applicationDetail.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationDescription(), APPLICATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationARN(), APPLICATIONARN_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationStatus(), APPLICATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(applicationDetail.inputDescriptions(), INPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.outputDescriptions(), OUTPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.referenceDataSourceDescriptions(), REFERENCEDATASOURCEDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.cloudWatchLoggingOptionDescriptions(), CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationCode(), APPLICATIONCODE_BINDING);
            protocolMarshaller.marshall((Object)applicationDetail.applicationVersionId(), APPLICATIONVERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

