/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.waiters.DescribeStreamFunction;
import software.amazon.awssdk.services.kinesis.waiters.StreamExists;
import software.amazon.awssdk.services.kinesis.waiters.StreamNotExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class KinesisClientWaiters {
    private final KinesisClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public KinesisClientWaiters(KinesisClient client) {
        this.client = client;
    }

    public Waiter<DescribeStreamRequest> streamExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStreamFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamExists.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(18), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStreamRequest> streamNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStreamFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamNotExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(18), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }
}

