/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.transform.HashKeyRangeUnmarshaller;
import software.amazon.awssdk.services.kinesis.transform.SequenceNumberRangeUnmarshaller;

public class ShardUnmarshaller
implements Unmarshaller<Shard, JsonUnmarshallerContext> {
    private static ShardUnmarshaller INSTANCE;

    public Shard unmarshall(JsonUnmarshallerContext context) throws Exception {
        Shard.Builder shardBuilder = Shard.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ShardId", targetDepth)) {
                    context.nextToken();
                    shardBuilder.shardId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParentShardId", targetDepth)) {
                    context.nextToken();
                    shardBuilder.parentShardId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AdjacentParentShardId", targetDepth)) {
                    context.nextToken();
                    shardBuilder.adjacentParentShardId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HashKeyRange", targetDepth)) {
                    context.nextToken();
                    shardBuilder.hashKeyRange(HashKeyRangeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SequenceNumberRange", targetDepth)) {
                    context.nextToken();
                    shardBuilder.sequenceNumberRange(SequenceNumberRangeUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Shard)shardBuilder.build();
    }

    public static ShardUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShardUnmarshaller();
        }
        return INSTANCE;
    }
}

