/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;

@SdkInternalApi
public class HashKeyRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingHashKey").build();
    private static final MarshallingInfo<String> ENDINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingHashKey").build();
    private static final HashKeyRangeMarshaller instance = new HashKeyRangeMarshaller();

    public static HashKeyRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(HashKeyRange hashKeyRange, ProtocolMarshaller protocolMarshaller) {
        if (hashKeyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hashKeyRange.startingHashKey(), STARTINGHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)hashKeyRange.endingHashKey(), ENDINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

