/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.CopyCommand;

@SdkInternalApi
public class CopyCommandMarshaller {
    private static final MarshallingInfo<String> DATATABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableName").build();
    private static final MarshallingInfo<String> DATATABLECOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableColumns").build();
    private static final MarshallingInfo<String> COPYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyOptions").build();
    private static final CopyCommandMarshaller instance = new CopyCommandMarshaller();

    public static CopyCommandMarshaller getInstance() {
        return instance;
    }

    public void marshall(CopyCommand copyCommand, ProtocolMarshaller protocolMarshaller) {
        if (copyCommand == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)copyCommand.dataTableName(), DATATABLENAME_BINDING);
            protocolMarshaller.marshall((Object)copyCommand.dataTableColumns(), DATATABLECOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)copyCommand.copyOptions(), COPYOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

