/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.firehose.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Record
implements StructuredPojo,
ToCopyableBuilder<Builder, Record> {
    private final ByteBuffer data;

    private Record(BuilderImpl builder) {
        this.data = builder.data;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        return other.data() == null || other.data().equals(this.data());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.setData(model.data);
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Record> {
        public Builder data(ByteBuffer var1);
    }
}

