/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints;
import software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDestinationConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
    private final String roleARN;
    private final String domainARN;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final ElasticsearchBufferingHints bufferingHints;
    private final ElasticsearchRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String domainARN() {
        return this.domainARN;
    }

    public String indexName() {
        return this.indexName;
    }

    public String typeName() {
        return this.typeName;
    }

    public String indexRotationPeriod() {
        return this.indexRotationPeriod;
    }

    public ElasticsearchBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public ElasticsearchRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public String s3BackupMode() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.domainARN() == null ? 0 : this.domainARN().hashCode());
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.indexRotationPeriod() == null ? 0 : this.indexRotationPeriod().hashCode());
        hashCode = 31 * hashCode + (this.bufferingHints() == null ? 0 : this.bufferingHints().hashCode());
        hashCode = 31 * hashCode + (this.retryOptions() == null ? 0 : this.retryOptions().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupMode() == null ? 0 : this.s3BackupMode().hashCode());
        hashCode = 31 * hashCode + (this.s3Configuration() == null ? 0 : this.s3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.processingConfiguration() == null ? 0 : this.processingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationConfiguration)) {
            return false;
        }
        ElasticsearchDestinationConfiguration other = (ElasticsearchDestinationConfiguration)obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.domainARN() == null ^ this.domainARN() == null) {
            return false;
        }
        if (other.domainARN() != null && !other.domainARN().equals(this.domainARN())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.indexRotationPeriod() == null ^ this.indexRotationPeriod() == null) {
            return false;
        }
        if (other.indexRotationPeriod() != null && !other.indexRotationPeriod().equals(this.indexRotationPeriod())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3BackupMode() == null ^ this.s3BackupMode() == null) {
            return false;
        }
        if (other.s3BackupMode() != null && !other.s3BackupMode().equals(this.s3BackupMode())) {
            return false;
        }
        if (other.s3Configuration() == null ^ this.s3Configuration() == null) {
            return false;
        }
        if (other.s3Configuration() != null && !other.s3Configuration().equals(this.s3Configuration())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptions() == null || other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.domainARN() != null) {
            sb.append("DomainARN: ").append(this.domainARN()).append(",");
        }
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.indexRotationPeriod() != null) {
            sb.append("IndexRotationPeriod: ").append(this.indexRotationPeriod()).append(",");
        }
        if (this.bufferingHints() != null) {
            sb.append("BufferingHints: ").append(this.bufferingHints()).append(",");
        }
        if (this.retryOptions() != null) {
            sb.append("RetryOptions: ").append(this.retryOptions()).append(",");
        }
        if (this.s3BackupMode() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupMode()).append(",");
        }
        if (this.s3Configuration() != null) {
            sb.append("S3Configuration: ").append(this.s3Configuration()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private ElasticsearchBufferingHints bufferingHints;
        private ElasticsearchRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationConfiguration model) {
            this.setRoleARN(model.roleARN);
            this.setDomainARN(model.domainARN);
            this.setIndexName(model.indexName);
            this.setTypeName(model.typeName);
            this.setIndexRotationPeriod(model.indexRotationPeriod);
            this.setBufferingHints(model.bufferingHints);
            this.setRetryOptions(model.retryOptions);
            this.setS3BackupMode(model.s3BackupMode);
            this.setS3Configuration(model.s3Configuration);
            this.setProcessingConfiguration(model.processingConfiguration);
            this.setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriod() {
            return this.indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
        }

        public final ElasticsearchBufferingHints getBufferingHints() {
            return this.bufferingHints;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
        }

        public final ElasticsearchRetryOptions getRetryOptions() {
            return this.retryOptions;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final void setS3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
        }

        public final S3DestinationConfiguration getS3Configuration() {
            return this.s3Configuration;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return this.processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        public ElasticsearchDestinationConfiguration build() {
            return new ElasticsearchDestinationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod var1);

        public Builder bufferingHints(ElasticsearchBufferingHints var1);

        public Builder retryOptions(ElasticsearchRetryOptions var1);

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(ElasticsearchS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        public Builder processingConfiguration(ProcessingConfiguration var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);
    }
}

