/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesisanalytics.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ApplicationDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ApplicationDetailUnmarshaller implements Unmarshaller<ApplicationDetail, JsonUnmarshallerContext> {

    public ApplicationDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ApplicationDetail.Builder applicationDetailBuilder = ApplicationDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApplicationDescription", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApplicationARN", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApplicationStatus", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreateTimestamp", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.createTimestamp(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("LastUpdateTimestamp", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.lastUpdateTimestamp(context.getUnmarshaller(java.util.Date.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InputDescriptions", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.inputDescriptions(new ListUnmarshaller<InputDescription>(
                            InputDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("OutputDescriptions", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.outputDescriptions(new ListUnmarshaller<OutputDescription>(
                            OutputDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ReferenceDataSourceDescriptions", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder
                            .referenceDataSourceDescriptions(new ListUnmarshaller<ReferenceDataSourceDescription>(
                                    ReferenceDataSourceDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptionDescriptions", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder
                            .cloudWatchLoggingOptionDescriptions(new ListUnmarshaller<CloudWatchLoggingOptionDescription>(
                                    CloudWatchLoggingOptionDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ApplicationCode", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ApplicationVersionId", targetDepth)) {
                    context.nextToken();
                    applicationDetailBuilder.applicationVersionId(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return applicationDetailBuilder.build();
    }

    private static ApplicationDetailUnmarshaller INSTANCE;

    public static ApplicationDetailUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ApplicationDetailUnmarshaller();
        return INSTANCE;
    }
}