/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
 * created in the in-application stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SourceSchema implements StructuredPojo, ToCopyableBuilder<SourceSchema.Builder, SourceSchema> {
    private final RecordFormat recordFormat;

    private final String recordEncoding;

    private final List<RecordColumn> recordColumns;

    private SourceSchema(BuilderImpl builder) {
        this.recordFormat = builder.recordFormat;
        this.recordEncoding = builder.recordEncoding;
        this.recordColumns = builder.recordColumns;
    }

    /**
     * <p>
     * Specifies the format of the records on the streaming source.
     * </p>
     * 
     * @return Specifies the format of the records on the streaming source.
     */
    public RecordFormat recordFormat() {
        return recordFormat;
    }

    /**
     * <p>
     * Specifies the encoding of the records in the streaming source. For example, UTF-8.
     * </p>
     * 
     * @return Specifies the encoding of the records in the streaming source. For example, UTF-8.
     */
    public String recordEncoding() {
        return recordEncoding;
    }

    /**
     * <p>
     * A list of <code>RecordColumn</code> objects.
     * </p>
     * 
     * @return A list of <code>RecordColumn</code> objects.
     */
    public List<RecordColumn> recordColumns() {
        return recordColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordFormat() == null) ? 0 : recordFormat().hashCode());
        hashCode = 31 * hashCode + ((recordEncoding() == null) ? 0 : recordEncoding().hashCode());
        hashCode = 31 * hashCode + ((recordColumns() == null) ? 0 : recordColumns().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSchema)) {
            return false;
        }
        SourceSchema other = (SourceSchema) obj;
        if (other.recordFormat() == null ^ this.recordFormat() == null) {
            return false;
        }
        if (other.recordFormat() != null && !other.recordFormat().equals(this.recordFormat())) {
            return false;
        }
        if (other.recordEncoding() == null ^ this.recordEncoding() == null) {
            return false;
        }
        if (other.recordEncoding() != null && !other.recordEncoding().equals(this.recordEncoding())) {
            return false;
        }
        if (other.recordColumns() == null ^ this.recordColumns() == null) {
            return false;
        }
        if (other.recordColumns() != null && !other.recordColumns().equals(this.recordColumns())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recordFormat() != null) {
            sb.append("RecordFormat: ").append(recordFormat()).append(",");
        }
        if (recordEncoding() != null) {
            sb.append("RecordEncoding: ").append(recordEncoding()).append(",");
        }
        if (recordColumns() != null) {
            sb.append("RecordColumns: ").append(recordColumns()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SourceSchema> {
        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * 
         * @param recordFormat
         *        Specifies the format of the records on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFormat(RecordFormat recordFormat);

        /**
         * <p>
         * Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * </p>
         * 
         * @param recordEncoding
         *        Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordEncoding(String recordEncoding);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects.
         * </p>
         * 
         * @param recordColumns
         *        A list of <code>RecordColumn</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumns(Collection<RecordColumn> recordColumns);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRecordColumns(java.util.Collection)} or {@link #withRecordColumns(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param recordColumns
         *        A list of <code>RecordColumn</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumns(RecordColumn... recordColumns);
    }

    private static final class BuilderImpl implements Builder {
        private RecordFormat recordFormat;

        private String recordEncoding;

        private List<RecordColumn> recordColumns;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSchema model) {
            setRecordFormat(model.recordFormat);
            setRecordEncoding(model.recordEncoding);
            setRecordColumns(model.recordColumns);
        }

        public final RecordFormat getRecordFormat() {
            return recordFormat;
        }

        @Override
        public final Builder recordFormat(RecordFormat recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public final void setRecordFormat(RecordFormat recordFormat) {
            this.recordFormat = recordFormat;
        }

        public final String getRecordEncoding() {
            return recordEncoding;
        }

        @Override
        public final Builder recordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
            return this;
        }

        public final void setRecordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
        }

        public final Collection<RecordColumn> getRecordColumns() {
            return recordColumns;
        }

        @Override
        public final Builder recordColumns(Collection<RecordColumn> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copy(recordColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumns(RecordColumn... recordColumns) {
            if (this.recordColumns == null) {
                this.recordColumns = new ArrayList<>(recordColumns.length);
            }
            for (RecordColumn e : recordColumns) {
                this.recordColumns.add(e);
            }
            return this;
        }

        public final void setRecordColumns(Collection<RecordColumn> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copy(recordColumns);
        }

        @SafeVarargs
        public final void setRecordColumns(RecordColumn... recordColumns) {
            if (this.recordColumns == null) {
                this.recordColumns = new ArrayList<>(recordColumns.length);
            }
            for (RecordColumn e : recordColumns) {
                this.recordColumns.add(e);
            }
        }

        @Override
        public SourceSchema build() {
            return new SourceSchema(this);
        }
    }
}
