/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you update a reference data source configuration for an application, this object provides all the updated values
 * (such as the source bucket name and object key name), the in-application table name that is created, and updated
 * mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReferenceDataSourceUpdate implements StructuredPojo,
        ToCopyableBuilder<ReferenceDataSourceUpdate.Builder, ReferenceDataSourceUpdate> {
    private final String referenceId;

    private final String tableNameUpdate;

    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    /**
     * <p>
     * ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to get this
     * value.
     * </p>
     * 
     * @return ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to
     *         get this value.
     */
    public String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * In-application table name that is created by this update.
     * </p>
     * 
     * @return In-application table name that is created by this update.
     */
    public String tableNameUpdate() {
        return tableNameUpdate;
    }

    /**
     * <p>
     * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the
     * Amazon S3 object on your behalf and populate the in-application reference table.
     * </p>
     * 
     * @return Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to
     *         read the Amazon S3 object on your behalf and populate the in-application reference table.
     */
    public S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return s3ReferenceDataSourceUpdate;
    }

    /**
     *
     * @return
     */
    public SourceSchema referenceSchemaUpdate() {
        return referenceSchemaUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((referenceId() == null) ? 0 : referenceId().hashCode());
        hashCode = 31 * hashCode + ((tableNameUpdate() == null) ? 0 : tableNameUpdate().hashCode());
        hashCode = 31 * hashCode + ((s3ReferenceDataSourceUpdate() == null) ? 0 : s3ReferenceDataSourceUpdate().hashCode());
        hashCode = 31 * hashCode + ((referenceSchemaUpdate() == null) ? 0 : referenceSchemaUpdate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate) obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.tableNameUpdate() == null ^ this.tableNameUpdate() == null) {
            return false;
        }
        if (other.tableNameUpdate() != null && !other.tableNameUpdate().equals(this.tableNameUpdate())) {
            return false;
        }
        if (other.s3ReferenceDataSourceUpdate() == null ^ this.s3ReferenceDataSourceUpdate() == null) {
            return false;
        }
        if (other.s3ReferenceDataSourceUpdate() != null
                && !other.s3ReferenceDataSourceUpdate().equals(this.s3ReferenceDataSourceUpdate())) {
            return false;
        }
        if (other.referenceSchemaUpdate() == null ^ this.referenceSchemaUpdate() == null) {
            return false;
        }
        if (other.referenceSchemaUpdate() != null && !other.referenceSchemaUpdate().equals(this.referenceSchemaUpdate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (referenceId() != null) {
            sb.append("ReferenceId: ").append(referenceId()).append(",");
        }
        if (tableNameUpdate() != null) {
            sb.append("TableNameUpdate: ").append(tableNameUpdate()).append(",");
        }
        if (s3ReferenceDataSourceUpdate() != null) {
            sb.append("S3ReferenceDataSourceUpdate: ").append(s3ReferenceDataSourceUpdate()).append(",");
        }
        if (referenceSchemaUpdate() != null) {
            sb.append("ReferenceSchemaUpdate: ").append(referenceSchemaUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        /**
         * <p>
         * ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to get
         * this value.
         * </p>
         * 
         * @param referenceId
         *        ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to
         *        get this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * In-application table name that is created by this update.
         * </p>
         * 
         * @param tableNameUpdate
         *        In-application table name that is created by this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNameUpdate(String tableNameUpdate);

        /**
         * <p>
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read
         * the Amazon S3 object on your behalf and populate the in-application reference table.
         * </p>
         * 
         * @param s3ReferenceDataSourceUpdate
         *        Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume
         *        to read the Amazon S3 object on your behalf and populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate);

        /**
         *
         * @param referenceSchemaUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate);
    }

    private static final class BuilderImpl implements Builder {
        private String referenceId;

        private String tableNameUpdate;

        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            setReferenceId(model.referenceId);
            setTableNameUpdate(model.tableNameUpdate);
            setS3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            setReferenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableNameUpdate() {
            return tableNameUpdate;
        }

        @Override
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        public final S3ReferenceDataSourceUpdate getS3ReferenceDataSourceUpdate() {
            return s3ReferenceDataSourceUpdate;
        }

        @Override
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
        }

        public final SourceSchema getReferenceSchemaUpdate() {
            return referenceSchemaUpdate;
        }

        @Override
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        public final void setReferenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
        }

        @Override
        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }
    }
}
