/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private final List<ApplicationSummary> applicationSummaries;

    private final Boolean hasMoreApplications;

    private ListApplicationsResponse(BuilderImpl builder) {
        this.applicationSummaries = builder.applicationSummaries;
        this.hasMoreApplications = builder.hasMoreApplications;
    }

    /**
     * <p>
     * List of <code>ApplicationSummary</code> objects.
     * </p>
     * 
     * @return List of <code>ApplicationSummary</code> objects.
     */
    public List<ApplicationSummary> applicationSummaries() {
        return applicationSummaries;
    }

    /**
     * <p>
     * Returns true if there are more applications to retrieve.
     * </p>
     * 
     * @return Returns true if there are more applications to retrieve.
     */
    public Boolean hasMoreApplications() {
        return hasMoreApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationSummaries() == null) ? 0 : applicationSummaries().hashCode());
        hashCode = 31 * hashCode + ((hasMoreApplications() == null) ? 0 : hasMoreApplications().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        if (other.applicationSummaries() == null ^ this.applicationSummaries() == null) {
            return false;
        }
        if (other.applicationSummaries() != null && !other.applicationSummaries().equals(this.applicationSummaries())) {
            return false;
        }
        if (other.hasMoreApplications() == null ^ this.hasMoreApplications() == null) {
            return false;
        }
        if (other.hasMoreApplications() != null && !other.hasMoreApplications().equals(this.hasMoreApplications())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationSummaries() != null) {
            sb.append("ApplicationSummaries: ").append(applicationSummaries()).append(",");
        }
        if (hasMoreApplications() != null) {
            sb.append("HasMoreApplications: ").append(hasMoreApplications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries);

        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setApplicationSummaries(java.util.Collection)} or
         * {@link #withApplicationSummaries(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(ApplicationSummary... applicationSummaries);

        /**
         * <p>
         * Returns true if there are more applications to retrieve.
         * </p>
         * 
         * @param hasMoreApplications
         *        Returns true if there are more applications to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreApplications(Boolean hasMoreApplications);
    }

    private static final class BuilderImpl implements Builder {
        private List<ApplicationSummary> applicationSummaries;

        private Boolean hasMoreApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            setApplicationSummaries(model.applicationSummaries);
            setHasMoreApplications(model.hasMoreApplications);
        }

        public final Collection<ApplicationSummary> getApplicationSummaries() {
            return applicationSummaries;
        }

        @Override
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary... applicationSummaries) {
            if (this.applicationSummaries == null) {
                this.applicationSummaries = new ArrayList<>(applicationSummaries.length);
            }
            for (ApplicationSummary e : applicationSummaries) {
                this.applicationSummaries.add(e);
            }
            return this;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
        }

        @SafeVarargs
        public final void setApplicationSummaries(ApplicationSummary... applicationSummaries) {
            if (this.applicationSummaries == null) {
                this.applicationSummaries = new ArrayList<>(applicationSummaries.length);
            }
            for (ApplicationSummary e : applicationSummaries) {
                this.applicationSummaries.add(e);
            }
        }

        public final Boolean getHasMoreApplications() {
            return hasMoreApplications;
        }

        @Override
        public final Builder hasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
            return this;
        }

        public final void setHasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }
}
