/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.JSONMappingParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional mapping information when JSON is the record format on the streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JSONMappingParameters implements StructuredPojo,
        ToCopyableBuilder<JSONMappingParameters.Builder, JSONMappingParameters> {
    private final String recordRowPath;

    private JSONMappingParameters(BuilderImpl builder) {
        this.recordRowPath = builder.recordRowPath;
    }

    /**
     * <p>
     * Path to the top-level parent that contains the records.
     * </p>
     * <p>
     * For example, consider the following JSON record:
     * </p>
     * <p>
     * In the <code>RecordRowPath</code>, <code>"$"</code> refers to the root and path <code>"$.vehicle.Model"</code>
     * refers to the specific <code>"Model"</code> key in the JSON.
     * </p>
     * 
     * @return Path to the top-level parent that contains the records.</p>
     *         <p>
     *         For example, consider the following JSON record:
     *         </p>
     *         <p>
     *         In the <code>RecordRowPath</code>, <code>"$"</code> refers to the root and path
     *         <code>"$.vehicle.Model"</code> refers to the specific <code>"Model"</code> key in the JSON.
     */
    public String recordRowPath() {
        return recordRowPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordRowPath() == null) ? 0 : recordRowPath().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONMappingParameters)) {
            return false;
        }
        JSONMappingParameters other = (JSONMappingParameters) obj;
        if (other.recordRowPath() == null ^ this.recordRowPath() == null) {
            return false;
        }
        if (other.recordRowPath() != null && !other.recordRowPath().equals(this.recordRowPath())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recordRowPath() != null) {
            sb.append("RecordRowPath: ").append(recordRowPath()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JSONMappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JSONMappingParameters> {
        /**
         * <p>
         * Path to the top-level parent that contains the records.
         * </p>
         * <p>
         * For example, consider the following JSON record:
         * </p>
         * <p>
         * In the <code>RecordRowPath</code>, <code>"$"</code> refers to the root and path
         * <code>"$.vehicle.Model"</code> refers to the specific <code>"Model"</code> key in the JSON.
         * </p>
         * 
         * @param recordRowPath
         *        Path to the top-level parent that contains the records.</p>
         *        <p>
         *        For example, consider the following JSON record:
         *        </p>
         *        <p>
         *        In the <code>RecordRowPath</code>, <code>"$"</code> refers to the root and path
         *        <code>"$.vehicle.Model"</code> refers to the specific <code>"Model"</code> key in the JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordRowPath(String recordRowPath);
    }

    private static final class BuilderImpl implements Builder {
        private String recordRowPath;

        private BuilderImpl() {
        }

        private BuilderImpl(JSONMappingParameters model) {
            setRecordRowPath(model.recordRowPath);
        }

        public final String getRecordRowPath() {
            return recordRowPath;
        }

        @Override
        public final Builder recordRowPath(String recordRowPath) {
            this.recordRowPath = recordRowPath;
            return this;
        }

        public final void setRecordRowPath(String recordRowPath) {
            this.recordRowPath = recordRowPath;
        }

        @Override
        public JSONMappingParameters build() {
            return new JSONMappingParameters(this);
        }
    }
}
