/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to a specific input configuration (identified by the <code>InputId</code> of an application).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputUpdate implements StructuredPojo, ToCopyableBuilder<InputUpdate.Builder, InputUpdate> {
    private final String inputId;

    private final String namePrefixUpdate;

    private final KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

    private final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

    private final InputSchemaUpdate inputSchemaUpdate;

    private final InputParallelismUpdate inputParallelismUpdate;

    private InputUpdate(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefixUpdate = builder.namePrefixUpdate;
        this.kinesisStreamsInputUpdate = builder.kinesisStreamsInputUpdate;
        this.kinesisFirehoseInputUpdate = builder.kinesisFirehoseInputUpdate;
        this.inputSchemaUpdate = builder.inputSchemaUpdate;
        this.inputParallelismUpdate = builder.inputParallelismUpdate;
    }

    /**
     * <p>
     * Input ID of the application input to be updated.
     * </p>
     * 
     * @return Input ID of the application input to be updated.
     */
    public String inputId() {
        return inputId;
    }

    /**
     * <p>
     * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming source.
     * </p>
     * 
     * @return Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
     *         source.
     */
    public String namePrefixUpdate() {
        return namePrefixUpdate;
    }

    /**
     * <p>
     * If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM role
     * ARN.
     * </p>
     * 
     * @return If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM
     *         role ARN.
     */
    public KinesisStreamsInputUpdate kinesisStreamsInputUpdate() {
        return kinesisStreamsInputUpdate;
    }

    /**
     * <p>
     * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated stream
     * Amazon Resource Name (ARN) and IAM role ARN.
     * </p>
     * 
     * @return If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
     *         stream Amazon Resource Name (ARN) and IAM role ARN.
     */
    public KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate() {
        return kinesisFirehoseInputUpdate;
    }

    /**
     * <p>
     * Describes the data format on the streaming source, and how record elements on the streaming source map to columns
     * of the in-application stream that is created.
     * </p>
     * 
     * @return Describes the data format on the streaming source, and how record elements on the streaming source map to
     *         columns of the in-application stream that is created.
     */
    public InputSchemaUpdate inputSchemaUpdate() {
        return inputSchemaUpdate;
    }

    /**
     * <p>
     * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
     * specific streaming source).
     * </p>
     * 
     * @return Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for
     *         the specific streaming source).
     */
    public InputParallelismUpdate inputParallelismUpdate() {
        return inputParallelismUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((inputId() == null) ? 0 : inputId().hashCode());
        hashCode = 31 * hashCode + ((namePrefixUpdate() == null) ? 0 : namePrefixUpdate().hashCode());
        hashCode = 31 * hashCode + ((kinesisStreamsInputUpdate() == null) ? 0 : kinesisStreamsInputUpdate().hashCode());
        hashCode = 31 * hashCode + ((kinesisFirehoseInputUpdate() == null) ? 0 : kinesisFirehoseInputUpdate().hashCode());
        hashCode = 31 * hashCode + ((inputSchemaUpdate() == null) ? 0 : inputSchemaUpdate().hashCode());
        hashCode = 31 * hashCode + ((inputParallelismUpdate() == null) ? 0 : inputParallelismUpdate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputUpdate)) {
            return false;
        }
        InputUpdate other = (InputUpdate) obj;
        if (other.inputId() == null ^ this.inputId() == null) {
            return false;
        }
        if (other.inputId() != null && !other.inputId().equals(this.inputId())) {
            return false;
        }
        if (other.namePrefixUpdate() == null ^ this.namePrefixUpdate() == null) {
            return false;
        }
        if (other.namePrefixUpdate() != null && !other.namePrefixUpdate().equals(this.namePrefixUpdate())) {
            return false;
        }
        if (other.kinesisStreamsInputUpdate() == null ^ this.kinesisStreamsInputUpdate() == null) {
            return false;
        }
        if (other.kinesisStreamsInputUpdate() != null
                && !other.kinesisStreamsInputUpdate().equals(this.kinesisStreamsInputUpdate())) {
            return false;
        }
        if (other.kinesisFirehoseInputUpdate() == null ^ this.kinesisFirehoseInputUpdate() == null) {
            return false;
        }
        if (other.kinesisFirehoseInputUpdate() != null
                && !other.kinesisFirehoseInputUpdate().equals(this.kinesisFirehoseInputUpdate())) {
            return false;
        }
        if (other.inputSchemaUpdate() == null ^ this.inputSchemaUpdate() == null) {
            return false;
        }
        if (other.inputSchemaUpdate() != null && !other.inputSchemaUpdate().equals(this.inputSchemaUpdate())) {
            return false;
        }
        if (other.inputParallelismUpdate() == null ^ this.inputParallelismUpdate() == null) {
            return false;
        }
        if (other.inputParallelismUpdate() != null && !other.inputParallelismUpdate().equals(this.inputParallelismUpdate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (inputId() != null) {
            sb.append("InputId: ").append(inputId()).append(",");
        }
        if (namePrefixUpdate() != null) {
            sb.append("NamePrefixUpdate: ").append(namePrefixUpdate()).append(",");
        }
        if (kinesisStreamsInputUpdate() != null) {
            sb.append("KinesisStreamsInputUpdate: ").append(kinesisStreamsInputUpdate()).append(",");
        }
        if (kinesisFirehoseInputUpdate() != null) {
            sb.append("KinesisFirehoseInputUpdate: ").append(kinesisFirehoseInputUpdate()).append(",");
        }
        if (inputSchemaUpdate() != null) {
            sb.append("InputSchemaUpdate: ").append(inputSchemaUpdate()).append(",");
        }
        if (inputParallelismUpdate() != null) {
            sb.append("InputParallelismUpdate: ").append(inputParallelismUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputUpdate> {
        /**
         * <p>
         * Input ID of the application input to be updated.
         * </p>
         * 
         * @param inputId
         *        Input ID of the application input to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific streaming
         * source.
         * </p>
         * 
         * @param namePrefixUpdate
         *        Name prefix for in-application streams that Amazon Kinesis Analytics creates for the specific
         *        streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefixUpdate(String namePrefixUpdate);

        /**
         * <p>
         * If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and IAM role
         * ARN.
         * </p>
         * 
         * @param kinesisStreamsInputUpdate
         *        If a Amazon Kinesis stream is the streaming source to be updated, provides an updated stream ARN and
         *        IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate);

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an updated
         * stream Amazon Resource Name (ARN) and IAM role ARN.
         * </p>
         * 
         * @param kinesisFirehoseInputUpdate
         *        If an Amazon Kinesis Firehose delivery stream is the streaming source to be updated, provides an
         *        updated stream Amazon Resource Name (ARN) and IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate);

        /**
         * <p>
         * Describes the data format on the streaming source, and how record elements on the streaming source map to
         * columns of the in-application stream that is created.
         * </p>
         * 
         * @param inputSchemaUpdate
         *        Describes the data format on the streaming source, and how record elements on the streaming source map
         *        to columns of the in-application stream that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate);

        /**
         * <p>
         * Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates for the
         * specific streaming source).
         * </p>
         * 
         * @param inputParallelismUpdate
         *        Describes the parallelism updates (the number in-application streams Amazon Kinesis Analytics creates
         *        for the specific streaming source).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate);
    }

    private static final class BuilderImpl implements Builder {
        private String inputId;

        private String namePrefixUpdate;

        private KinesisStreamsInputUpdate kinesisStreamsInputUpdate;

        private KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;

        private InputSchemaUpdate inputSchemaUpdate;

        private InputParallelismUpdate inputParallelismUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputUpdate model) {
            setInputId(model.inputId);
            setNamePrefixUpdate(model.namePrefixUpdate);
            setKinesisStreamsInputUpdate(model.kinesisStreamsInputUpdate);
            setKinesisFirehoseInputUpdate(model.kinesisFirehoseInputUpdate);
            setInputSchemaUpdate(model.inputSchemaUpdate);
            setInputParallelismUpdate(model.inputParallelismUpdate);
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefixUpdate() {
            return namePrefixUpdate;
        }

        @Override
        public final Builder namePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
            return this;
        }

        public final void setNamePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
        }

        public final KinesisStreamsInputUpdate getKinesisStreamsInputUpdate() {
            return kinesisStreamsInputUpdate;
        }

        @Override
        public final Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
            return this;
        }

        public final void setKinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
        }

        public final KinesisFirehoseInputUpdate getKinesisFirehoseInputUpdate() {
            return kinesisFirehoseInputUpdate;
        }

        @Override
        public final Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
            return this;
        }

        public final void setKinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
        }

        public final InputSchemaUpdate getInputSchemaUpdate() {
            return inputSchemaUpdate;
        }

        @Override
        public final Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
            return this;
        }

        public final void setInputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
        }

        public final InputParallelismUpdate getInputParallelismUpdate() {
            return inputParallelismUpdate;
        }

        @Override
        public final Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
            return this;
        }

        public final void setInputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
        }

        @Override
        public InputUpdate build() {
            return new InputUpdate(this);
        }
    }
}
