/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application input configuration. For more information, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
 * Input</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputDescription implements StructuredPojo, ToCopyableBuilder<InputDescription.Builder, InputDescription> {
    private final String inputId;

    private final String namePrefix;

    private final List<String> inAppStreamNames;

    private final KinesisStreamsInputDescription kinesisStreamsInputDescription;

    private final KinesisFirehoseInputDescription kinesisFirehoseInputDescription;

    private final SourceSchema inputSchema;

    private final InputParallelism inputParallelism;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputDescription(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefix = builder.namePrefix;
        this.inAppStreamNames = builder.inAppStreamNames;
        this.kinesisStreamsInputDescription = builder.kinesisStreamsInputDescription;
        this.kinesisFirehoseInputDescription = builder.kinesisFirehoseInputDescription;
        this.inputSchema = builder.inputSchema;
        this.inputParallelism = builder.inputParallelism;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    /**
     * <p>
     * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each
     * input configuration you add to your application.
     * </p>
     * 
     * @return Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to
     *         each input configuration you add to your application.
     */
    public String inputId() {
        return inputId;
    }

    /**
     * <p>
     * In-application name prefix.
     * </p>
     * 
     * @return In-application name prefix.
     */
    public String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * Returns the in-application stream names that are mapped to the stream source.
     * </p>
     * 
     * @return Returns the in-application stream names that are mapped to the stream source.
     */
    public List<String> inAppStreamNames() {
        return inAppStreamNames;
    }

    /**
     * <p>
     * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and an IAM
     * role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * </p>
     * 
     * @return If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and
     *         an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public KinesisStreamsInputDescription kinesisStreamsInputDescription() {
        return kinesisStreamsInputDescription;
    }

    /**
     * <p>
     * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose delivery
     * stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on
     * your behalf.
     * </p>
     * 
     * @return If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose
     *         delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to
     *         access the stream on your behalf.
     */
    public KinesisFirehoseInputDescription kinesisFirehoseInputDescription() {
        return kinesisFirehoseInputDescription;
    }

    /**
     *
     * @return
     */
    public SourceSchema inputSchema() {
        return inputSchema;
    }

    /**
     * <p>
     * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
     * </p>
     * 
     * @return Describes the configured parallelism (number of in-application streams mapped to the streaming source).
     */
    public InputParallelism inputParallelism() {
        return inputParallelism;
    }

    /**
     * <p>
     * Point at which the application is configured to read from the input stream.
     * </p>
     * 
     * @return Point at which the application is configured to read from the input stream.
     */
    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((inputId() == null) ? 0 : inputId().hashCode());
        hashCode = 31 * hashCode + ((namePrefix() == null) ? 0 : namePrefix().hashCode());
        hashCode = 31 * hashCode + ((inAppStreamNames() == null) ? 0 : inAppStreamNames().hashCode());
        hashCode = 31 * hashCode + ((kinesisStreamsInputDescription() == null) ? 0 : kinesisStreamsInputDescription().hashCode());
        hashCode = 31 * hashCode
                + ((kinesisFirehoseInputDescription() == null) ? 0 : kinesisFirehoseInputDescription().hashCode());
        hashCode = 31 * hashCode + ((inputSchema() == null) ? 0 : inputSchema().hashCode());
        hashCode = 31 * hashCode + ((inputParallelism() == null) ? 0 : inputParallelism().hashCode());
        hashCode = 31 * hashCode
                + ((inputStartingPositionConfiguration() == null) ? 0 : inputStartingPositionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDescription)) {
            return false;
        }
        InputDescription other = (InputDescription) obj;
        if (other.inputId() == null ^ this.inputId() == null) {
            return false;
        }
        if (other.inputId() != null && !other.inputId().equals(this.inputId())) {
            return false;
        }
        if (other.namePrefix() == null ^ this.namePrefix() == null) {
            return false;
        }
        if (other.namePrefix() != null && !other.namePrefix().equals(this.namePrefix())) {
            return false;
        }
        if (other.inAppStreamNames() == null ^ this.inAppStreamNames() == null) {
            return false;
        }
        if (other.inAppStreamNames() != null && !other.inAppStreamNames().equals(this.inAppStreamNames())) {
            return false;
        }
        if (other.kinesisStreamsInputDescription() == null ^ this.kinesisStreamsInputDescription() == null) {
            return false;
        }
        if (other.kinesisStreamsInputDescription() != null
                && !other.kinesisStreamsInputDescription().equals(this.kinesisStreamsInputDescription())) {
            return false;
        }
        if (other.kinesisFirehoseInputDescription() == null ^ this.kinesisFirehoseInputDescription() == null) {
            return false;
        }
        if (other.kinesisFirehoseInputDescription() != null
                && !other.kinesisFirehoseInputDescription().equals(this.kinesisFirehoseInputDescription())) {
            return false;
        }
        if (other.inputSchema() == null ^ this.inputSchema() == null) {
            return false;
        }
        if (other.inputSchema() != null && !other.inputSchema().equals(this.inputSchema())) {
            return false;
        }
        if (other.inputParallelism() == null ^ this.inputParallelism() == null) {
            return false;
        }
        if (other.inputParallelism() != null && !other.inputParallelism().equals(this.inputParallelism())) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() == null ^ this.inputStartingPositionConfiguration() == null) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() != null
                && !other.inputStartingPositionConfiguration().equals(this.inputStartingPositionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (inputId() != null) {
            sb.append("InputId: ").append(inputId()).append(",");
        }
        if (namePrefix() != null) {
            sb.append("NamePrefix: ").append(namePrefix()).append(",");
        }
        if (inAppStreamNames() != null) {
            sb.append("InAppStreamNames: ").append(inAppStreamNames()).append(",");
        }
        if (kinesisStreamsInputDescription() != null) {
            sb.append("KinesisStreamsInputDescription: ").append(kinesisStreamsInputDescription()).append(",");
        }
        if (kinesisFirehoseInputDescription() != null) {
            sb.append("KinesisFirehoseInputDescription: ").append(kinesisFirehoseInputDescription()).append(",");
        }
        if (inputSchema() != null) {
            sb.append("InputSchema: ").append(inputSchema()).append(",");
        }
        if (inputParallelism() != null) {
            sb.append("InputParallelism: ").append(inputParallelism()).append(",");
        }
        if (inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(inputStartingPositionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputDescription> {
        /**
         * <p>
         * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each
         * input configuration you add to your application.
         * </p>
         * 
         * @param inputId
         *        Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns
         *        to each input configuration you add to your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * In-application name prefix.
         * </p>
         * 
         * @param namePrefix
         *        In-application name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * Returns the in-application stream names that are mapped to the stream source.
         * </p>
         * 
         * @param inAppStreamNames
         *        Returns the in-application stream names that are mapped to the stream source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppStreamNames(Collection<String> inAppStreamNames);

        /**
         * <p>
         * Returns the in-application stream names that are mapped to the stream source.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInAppStreamNames(java.util.Collection)} or {@link #withInAppStreamNames(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param inAppStreamNames
         *        Returns the in-application stream names that are mapped to the stream source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppStreamNames(String... inAppStreamNames);

        /**
         * <p>
         * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and an
         * IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * </p>
         * 
         * @param kinesisStreamsInputDescription
         *        If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN
         *        and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription);

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose
         * delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access
         * the stream on your behalf.
         * </p>
         * 
         * @param kinesisFirehoseInputDescription
         *        If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the
         *        Firehose delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis
         *        Analytics to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription);

        /**
         *
         * @param inputSchema
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);

        /**
         * <p>
         * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
         * </p>
         * 
         * @param inputParallelism
         *        Describes the configured parallelism (number of in-application streams mapped to the streaming
         *        source).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelism(InputParallelism inputParallelism);

        /**
         * <p>
         * Point at which the application is configured to read from the input stream.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        Point at which the application is configured to read from the input stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String inputId;

        private String namePrefix;

        private List<String> inAppStreamNames;

        private KinesisStreamsInputDescription kinesisStreamsInputDescription;

        private KinesisFirehoseInputDescription kinesisFirehoseInputDescription;

        private SourceSchema inputSchema;

        private InputParallelism inputParallelism;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDescription model) {
            setInputId(model.inputId);
            setNamePrefix(model.namePrefix);
            setInAppStreamNames(model.inAppStreamNames);
            setKinesisStreamsInputDescription(model.kinesisStreamsInputDescription);
            setKinesisFirehoseInputDescription(model.kinesisFirehoseInputDescription);
            setInputSchema(model.inputSchema);
            setInputParallelism(model.inputParallelism);
            setInputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final Collection<String> getInAppStreamNames() {
            return inAppStreamNames;
        }

        @Override
        public final Builder inAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppStreamNames(String... inAppStreamNames) {
            if (this.inAppStreamNames == null) {
                this.inAppStreamNames = new ArrayList<>(inAppStreamNames.length);
            }
            for (String e : inAppStreamNames) {
                this.inAppStreamNames.add(e);
            }
            return this;
        }

        public final void setInAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
        }

        @SafeVarargs
        public final void setInAppStreamNames(String... inAppStreamNames) {
            if (this.inAppStreamNames == null) {
                this.inAppStreamNames = new ArrayList<>(inAppStreamNames.length);
            }
            for (String e : inAppStreamNames) {
                this.inAppStreamNames.add(e);
            }
        }

        public final KinesisStreamsInputDescription getKinesisStreamsInputDescription() {
            return kinesisStreamsInputDescription;
        }

        @Override
        public final Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
            return this;
        }

        public final void setKinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
        }

        public final KinesisFirehoseInputDescription getKinesisFirehoseInputDescription() {
            return kinesisFirehoseInputDescription;
        }

        @Override
        public final Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
            return this;
        }

        public final void setKinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
        }

        public final SourceSchema getInputSchema() {
            return inputSchema;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
        }

        public final InputParallelism getInputParallelism() {
            return inputParallelism;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
        }

        public final InputStartingPositionConfiguration getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
        }

        @Override
        public InputDescription build() {
            return new InputDescription(this);
        }
    }
}
