/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you start your application, you provide this configuration, which identifies the input source and the point in
 * the input source at which you want the application to start processing records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputConfiguration implements StructuredPojo, ToCopyableBuilder<InputConfiguration.Builder, InputConfiguration> {
    private final String id;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    /**
     * <p>
     * Input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
     * </p>
     * 
     * @return Input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Point at which you want the application to start processing records from the streaming source.
     * </p>
     * 
     * @return Point at which you want the application to start processing records from the streaming source.
     */
    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode
                + ((inputStartingPositionConfiguration() == null) ? 0 : inputStartingPositionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() == null ^ this.inputStartingPositionConfiguration() == null) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() != null
                && !other.inputStartingPositionConfiguration().equals(this.inputStartingPositionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(inputStartingPositionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputConfiguration> {
        /**
         * <p>
         * Input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
         * </p>
         * 
         * @param id
         *        Input source ID. You can get this ID by calling the <a>DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Point at which you want the application to start processing records from the streaming source.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        Point at which you want the application to start processing records from the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            setId(model.id);
            setInputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final InputStartingPositionConfiguration getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
        }

        @Override
        public InputConfiguration build() {
            return new InputConfiguration(this);
        }
    }
}
