/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationOutputRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteApplicationOutputRequest.Builder, DeleteApplicationOutputRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String outputId;

    private DeleteApplicationOutputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.outputId = builder.outputId;
    }

    /**
     * <p>
     * Amazon Kinesis Analytics application name.
     * </p>
     * 
     * @return Amazon Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get the
     * current application version. If the version specified is not the current version, the
     * <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get
     *         the current application version. If the version specified is not the current version, the
     *         <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the configuration to delete. Each output configuration that is added to the application, either when
     * the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique ID. You need to
     * provide the ID to uniquely identify the output configuration that you want to delete from the application
     * configuration. You can use the <a>DescribeApplication</a> operation to get the specific <code>OutputId</code>.
     * </p>
     * 
     * @return The ID of the configuration to delete. Each output configuration that is added to the application, either
     *         when the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique
     *         ID. You need to provide the ID to uniquely identify the output configuration that you want to delete from
     *         the application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
     *         <code>OutputId</code>.
     */
    public String outputId() {
        return outputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((outputId() == null) ? 0 : outputId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationOutputRequest)) {
            return false;
        }
        DeleteApplicationOutputRequest other = (DeleteApplicationOutputRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.outputId() == null ^ this.outputId() == null) {
            return false;
        }
        if (other.outputId() != null && !other.outputId().equals(this.outputId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (outputId() != null) {
            sb.append("OutputId: ").append(outputId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteApplicationOutputRequest> {
        /**
         * <p>
         * Amazon Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        Amazon Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to get the
         * current application version. If the version specified is not the current version, the
         * <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Amazon Kinesis Analytics application version. You can use the <a>DescribeApplication</a> operation to
         *        get the current application version. If the version specified is not the current version, the
         *        <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the configuration to delete. Each output configuration that is added to the application, either
         * when the application is created or later using the <a>AddApplicationOutput</a> operation, has a unique ID.
         * You need to provide the ID to uniquely identify the output configuration that you want to delete from the
         * application configuration. You can use the <a>DescribeApplication</a> operation to get the specific
         * <code>OutputId</code>.
         * </p>
         * 
         * @param outputId
         *        The ID of the configuration to delete. Each output configuration that is added to the application,
         *        either when the application is created or later using the <a>AddApplicationOutput</a> operation, has a
         *        unique ID. You need to provide the ID to uniquely identify the output configuration that you want to
         *        delete from the application configuration. You can use the <a>DescribeApplication</a> operation to get
         *        the specific <code>OutputId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String outputId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationOutputRequest model) {
            setApplicationName(model.applicationName);
            setCurrentApplicationVersionId(model.currentApplicationVersionId);
            setOutputId(model.outputId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getOutputId() {
            return outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        public DeleteApplicationOutputRequest build() {
            return new DeleteApplicationOutputRequest(this);
        }
    }
}
