/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to apply to an existing Amazon Kinesis Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ApplicationUpdate implements StructuredPojo, ToCopyableBuilder<ApplicationUpdate.Builder, ApplicationUpdate> {
    private final List<InputUpdate> inputUpdates;

    private final String applicationCodeUpdate;

    private final List<OutputUpdate> outputUpdates;

    private final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;

    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private ApplicationUpdate(BuilderImpl builder) {
        this.inputUpdates = builder.inputUpdates;
        this.applicationCodeUpdate = builder.applicationCodeUpdate;
        this.outputUpdates = builder.outputUpdates;
        this.referenceDataSourceUpdates = builder.referenceDataSourceUpdates;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    /**
     * <p>
     * Describes application input configuration updates.
     * </p>
     * 
     * @return Describes application input configuration updates.
     */
    public List<InputUpdate> inputUpdates() {
        return inputUpdates;
    }

    /**
     * <p>
     * Describes application code updates.
     * </p>
     * 
     * @return Describes application code updates.
     */
    public String applicationCodeUpdate() {
        return applicationCodeUpdate;
    }

    /**
     * <p>
     * Describes application output configuration updates.
     * </p>
     * 
     * @return Describes application output configuration updates.
     */
    public List<OutputUpdate> outputUpdates() {
        return outputUpdates;
    }

    /**
     * <p>
     * Describes application reference data source updates.
     * </p>
     * 
     * @return Describes application reference data source updates.
     */
    public List<ReferenceDataSourceUpdate> referenceDataSourceUpdates() {
        return referenceDataSourceUpdates;
    }

    /**
     * <p>
     * Describes application CloudWatch logging option updates.
     * </p>
     * 
     * @return Describes application CloudWatch logging option updates.
     */
    public List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return cloudWatchLoggingOptionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((inputUpdates() == null) ? 0 : inputUpdates().hashCode());
        hashCode = 31 * hashCode + ((applicationCodeUpdate() == null) ? 0 : applicationCodeUpdate().hashCode());
        hashCode = 31 * hashCode + ((outputUpdates() == null) ? 0 : outputUpdates().hashCode());
        hashCode = 31 * hashCode + ((referenceDataSourceUpdates() == null) ? 0 : referenceDataSourceUpdates().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptionUpdates() == null) ? 0 : cloudWatchLoggingOptionUpdates().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationUpdate)) {
            return false;
        }
        ApplicationUpdate other = (ApplicationUpdate) obj;
        if (other.inputUpdates() == null ^ this.inputUpdates() == null) {
            return false;
        }
        if (other.inputUpdates() != null && !other.inputUpdates().equals(this.inputUpdates())) {
            return false;
        }
        if (other.applicationCodeUpdate() == null ^ this.applicationCodeUpdate() == null) {
            return false;
        }
        if (other.applicationCodeUpdate() != null && !other.applicationCodeUpdate().equals(this.applicationCodeUpdate())) {
            return false;
        }
        if (other.outputUpdates() == null ^ this.outputUpdates() == null) {
            return false;
        }
        if (other.outputUpdates() != null && !other.outputUpdates().equals(this.outputUpdates())) {
            return false;
        }
        if (other.referenceDataSourceUpdates() == null ^ this.referenceDataSourceUpdates() == null) {
            return false;
        }
        if (other.referenceDataSourceUpdates() != null
                && !other.referenceDataSourceUpdates().equals(this.referenceDataSourceUpdates())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionUpdates() == null ^ this.cloudWatchLoggingOptionUpdates() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptionUpdates() != null
                && !other.cloudWatchLoggingOptionUpdates().equals(this.cloudWatchLoggingOptionUpdates())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (inputUpdates() != null) {
            sb.append("InputUpdates: ").append(inputUpdates()).append(",");
        }
        if (applicationCodeUpdate() != null) {
            sb.append("ApplicationCodeUpdate: ").append(applicationCodeUpdate()).append(",");
        }
        if (outputUpdates() != null) {
            sb.append("OutputUpdates: ").append(outputUpdates()).append(",");
        }
        if (referenceDataSourceUpdates() != null) {
            sb.append("ReferenceDataSourceUpdates: ").append(referenceDataSourceUpdates()).append(",");
        }
        if (cloudWatchLoggingOptionUpdates() != null) {
            sb.append("CloudWatchLoggingOptionUpdates: ").append(cloudWatchLoggingOptionUpdates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationUpdate> {
        /**
         * <p>
         * Describes application input configuration updates.
         * </p>
         * 
         * @param inputUpdates
         *        Describes application input configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputUpdates(Collection<InputUpdate> inputUpdates);

        /**
         * <p>
         * Describes application input configuration updates.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInputUpdates(java.util.Collection)} or {@link #withInputUpdates(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param inputUpdates
         *        Describes application input configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputUpdates(InputUpdate... inputUpdates);

        /**
         * <p>
         * Describes application code updates.
         * </p>
         * 
         * @param applicationCodeUpdate
         *        Describes application code updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeUpdate(String applicationCodeUpdate);

        /**
         * <p>
         * Describes application output configuration updates.
         * </p>
         * 
         * @param outputUpdates
         *        Describes application output configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUpdates(Collection<OutputUpdate> outputUpdates);

        /**
         * <p>
         * Describes application output configuration updates.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOutputUpdates(java.util.Collection)} or {@link #withOutputUpdates(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param outputUpdates
         *        Describes application output configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUpdates(OutputUpdate... outputUpdates);

        /**
         * <p>
         * Describes application reference data source updates.
         * </p>
         * 
         * @param referenceDataSourceUpdates
         *        Describes application reference data source updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates);

        /**
         * <p>
         * Describes application reference data source updates.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setReferenceDataSourceUpdates(java.util.Collection)} or
         * {@link #withReferenceDataSourceUpdates(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param referenceDataSourceUpdates
         *        Describes application reference data source updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate... referenceDataSourceUpdates);

        /**
         * <p>
         * Describes application CloudWatch logging option updates.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application CloudWatch logging option updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * Describes application CloudWatch logging option updates.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCloudWatchLoggingOptionUpdates(java.util.Collection)} or
         * {@link #withCloudWatchLoggingOptionUpdates(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application CloudWatch logging option updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates);
    }

    private static final class BuilderImpl implements Builder {
        private List<InputUpdate> inputUpdates;

        private String applicationCodeUpdate;

        private List<OutputUpdate> outputUpdates;

        private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;

        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationUpdate model) {
            setInputUpdates(model.inputUpdates);
            setApplicationCodeUpdate(model.applicationCodeUpdate);
            setOutputUpdates(model.outputUpdates);
            setReferenceDataSourceUpdates(model.referenceDataSourceUpdates);
            setCloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final Collection<InputUpdate> getInputUpdates() {
            return inputUpdates;
        }

        @Override
        public final Builder inputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputUpdates(InputUpdate... inputUpdates) {
            if (this.inputUpdates == null) {
                this.inputUpdates = new ArrayList<>(inputUpdates.length);
            }
            for (InputUpdate e : inputUpdates) {
                this.inputUpdates.add(e);
            }
            return this;
        }

        public final void setInputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
        }

        @SafeVarargs
        public final void setInputUpdates(InputUpdate... inputUpdates) {
            if (this.inputUpdates == null) {
                this.inputUpdates = new ArrayList<>(inputUpdates.length);
            }
            for (InputUpdate e : inputUpdates) {
                this.inputUpdates.add(e);
            }
        }

        public final String getApplicationCodeUpdate() {
            return applicationCodeUpdate;
        }

        @Override
        public final Builder applicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
            return this;
        }

        public final void setApplicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
        }

        public final Collection<OutputUpdate> getOutputUpdates() {
            return outputUpdates;
        }

        @Override
        public final Builder outputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputUpdates(OutputUpdate... outputUpdates) {
            if (this.outputUpdates == null) {
                this.outputUpdates = new ArrayList<>(outputUpdates.length);
            }
            for (OutputUpdate e : outputUpdates) {
                this.outputUpdates.add(e);
            }
            return this;
        }

        public final void setOutputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
        }

        @SafeVarargs
        public final void setOutputUpdates(OutputUpdate... outputUpdates) {
            if (this.outputUpdates == null) {
                this.outputUpdates = new ArrayList<>(outputUpdates.length);
            }
            for (OutputUpdate e : outputUpdates) {
                this.outputUpdates.add(e);
            }
        }

        public final Collection<ReferenceDataSourceUpdate> getReferenceDataSourceUpdates() {
            return referenceDataSourceUpdates;
        }

        @Override
        public final Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate... referenceDataSourceUpdates) {
            if (this.referenceDataSourceUpdates == null) {
                this.referenceDataSourceUpdates = new ArrayList<>(referenceDataSourceUpdates.length);
            }
            for (ReferenceDataSourceUpdate e : referenceDataSourceUpdates) {
                this.referenceDataSourceUpdates.add(e);
            }
            return this;
        }

        public final void setReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
        }

        @SafeVarargs
        public final void setReferenceDataSourceUpdates(ReferenceDataSourceUpdate... referenceDataSourceUpdates) {
            if (this.referenceDataSourceUpdates == null) {
                this.referenceDataSourceUpdates = new ArrayList<>(referenceDataSourceUpdates.length);
            }
            for (ReferenceDataSourceUpdate e : referenceDataSourceUpdates) {
                this.referenceDataSourceUpdates.add(e);
            }
        }

        public final Collection<CloudWatchLoggingOptionUpdate> getCloudWatchLoggingOptionUpdates() {
            return cloudWatchLoggingOptionUpdates;
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates) {
            if (this.cloudWatchLoggingOptionUpdates == null) {
                this.cloudWatchLoggingOptionUpdates = new ArrayList<>(cloudWatchLoggingOptionUpdates.length);
            }
            for (CloudWatchLoggingOptionUpdate e : cloudWatchLoggingOptionUpdates) {
                this.cloudWatchLoggingOptionUpdates.add(e);
            }
            return this;
        }

        public final void setCloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
        }

        @SafeVarargs
        public final void setCloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates) {
            if (this.cloudWatchLoggingOptionUpdates == null) {
                this.cloudWatchLoggingOptionUpdates = new ArrayList<>(cloudWatchLoggingOptionUpdates.length);
            }
            for (CloudWatchLoggingOptionUpdate e : cloudWatchLoggingOptionUpdates) {
                this.cloudWatchLoggingOptionUpdates.add(e);
            }
        }

        @Override
        public ApplicationUpdate build() {
            return new ApplicationUpdate(this);
        }
    }
}
