/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationInputRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddApplicationInputRequest.Builder, AddApplicationInputRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final Input input;

    private AddApplicationInputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.input = builder.input;
    }

    /**
     * <p>
     * Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
     * </p>
     * 
     * @return Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
     * operation to find the current application version.
     * </p>
     * 
     * @return Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
     *         operation to find the current application version.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Input input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputRequest)) {
            return false;
        }
        AddApplicationInputRequest other = (AddApplicationInputRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddApplicationInputRequest> {
        /**
         * <p>
         * Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
         * </p>
         * 
         * @param applicationName
         *        Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
         * operation to find the current application version.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Current version of your Amazon Kinesis Analytics application. You can use the
         *        <a>DescribeApplication</a> operation to find the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p/>
         * 
         * @param input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputRequest model) {
            setApplicationName(model.applicationName);
            setCurrentApplicationVersionId(model.currentApplicationVersionId);
            setInput(model.input);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final Input getInput() {
            return input;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input input) {
            this.input = input;
        }

        @Override
        public AddApplicationInputRequest build() {
            return new AddApplicationInputRequest(this);
        }
    }
}
