/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesis.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>DescribeStream</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamDescription implements StructuredPojo, ToCopyableBuilder<StreamDescription.Builder, StreamDescription> {
    private final String streamName;

    private final String streamARN;

    private final String streamStatus;

    private final List<Shard> shards;

    private final Boolean hasMoreShards;

    private final Integer retentionPeriodHours;

    private final Date streamCreationTimestamp;

    private final List<EnhancedMetrics> enhancedMonitoring;

    private StreamDescription(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.shards = builder.shards;
        this.hasMoreShards = builder.hasMoreShards;
        this.retentionPeriodHours = builder.retentionPeriodHours;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.enhancedMonitoring = builder.enhancedMonitoring;
    }

    /**
     * <p>
     * The name of the stream being described.
     * </p>
     * 
     * @return The name of the stream being described.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream being described.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The current status of the stream being described. The stream status is one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
     * <code>StreamStatus</code> to <code>CREATING</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The stream is being deleted. The specified stream is in the <code>DELETING</code> state
     * until Amazon Kinesis completes the deletion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You should
     * perform read and write operations only on an <code>ACTIVE</code> stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations continue to
     * work while the stream is in the <code>UPDATING</code> state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the stream being described. The stream status is one of the following states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
     *         <code>StreamStatus</code> to <code>CREATING</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The stream is being deleted. The specified stream is in the <code>DELETING</code>
     *         state until Amazon Kinesis completes the deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You
     *         should perform read and write operations only on an <code>ACTIVE</code> stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations
     *         continue to work while the stream is in the <code>UPDATING</code> state.
     *         </p>
     *         </li>
     * @see StreamStatus
     */
    public String streamStatus() {
        return streamStatus;
    }

    /**
     * <p>
     * The shards that comprise the stream.
     * </p>
     * 
     * @return The shards that comprise the stream.
     */
    public List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * If set to <code>true</code>, more shards in the stream are available to describe.
     * </p>
     * 
     * @return If set to <code>true</code>, more shards in the stream are available to describe.
     */
    public Boolean hasMoreShards() {
        return hasMoreShards;
    }

    /**
     * <p>
     * The current retention period, in hours.
     * </p>
     * 
     * @return The current retention period, in hours.
     */
    public Integer retentionPeriodHours() {
        return retentionPeriodHours;
    }

    /**
     * <p>
     * The approximate time that the stream was created.
     * </p>
     * 
     * @return The approximate time that the stream was created.
     */
    public Date streamCreationTimestamp() {
        return streamCreationTimestamp;
    }

    /**
     * <p>
     * Represents the current enhanced monitoring settings of the stream.
     * </p>
     * 
     * @return Represents the current enhanced monitoring settings of the stream.
     */
    public List<EnhancedMetrics> enhancedMonitoring() {
        return enhancedMonitoring;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((streamARN() == null) ? 0 : streamARN().hashCode());
        hashCode = 31 * hashCode + ((streamStatus() == null) ? 0 : streamStatus().hashCode());
        hashCode = 31 * hashCode + ((shards() == null) ? 0 : shards().hashCode());
        hashCode = 31 * hashCode + ((hasMoreShards() == null) ? 0 : hasMoreShards().hashCode());
        hashCode = 31 * hashCode + ((retentionPeriodHours() == null) ? 0 : retentionPeriodHours().hashCode());
        hashCode = 31 * hashCode + ((streamCreationTimestamp() == null) ? 0 : streamCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + ((enhancedMonitoring() == null) ? 0 : enhancedMonitoring().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.streamARN() == null ^ this.streamARN() == null) {
            return false;
        }
        if (other.streamARN() != null && !other.streamARN().equals(this.streamARN())) {
            return false;
        }
        if (other.streamStatus() == null ^ this.streamStatus() == null) {
            return false;
        }
        if (other.streamStatus() != null && !other.streamStatus().equals(this.streamStatus())) {
            return false;
        }
        if (other.shards() == null ^ this.shards() == null) {
            return false;
        }
        if (other.shards() != null && !other.shards().equals(this.shards())) {
            return false;
        }
        if (other.hasMoreShards() == null ^ this.hasMoreShards() == null) {
            return false;
        }
        if (other.hasMoreShards() != null && !other.hasMoreShards().equals(this.hasMoreShards())) {
            return false;
        }
        if (other.retentionPeriodHours() == null ^ this.retentionPeriodHours() == null) {
            return false;
        }
        if (other.retentionPeriodHours() != null && !other.retentionPeriodHours().equals(this.retentionPeriodHours())) {
            return false;
        }
        if (other.streamCreationTimestamp() == null ^ this.streamCreationTimestamp() == null) {
            return false;
        }
        if (other.streamCreationTimestamp() != null && !other.streamCreationTimestamp().equals(this.streamCreationTimestamp())) {
            return false;
        }
        if (other.enhancedMonitoring() == null ^ this.enhancedMonitoring() == null) {
            return false;
        }
        if (other.enhancedMonitoring() != null && !other.enhancedMonitoring().equals(this.enhancedMonitoring())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (streamARN() != null) {
            sb.append("StreamARN: ").append(streamARN()).append(",");
        }
        if (streamStatus() != null) {
            sb.append("StreamStatus: ").append(streamStatus()).append(",");
        }
        if (shards() != null) {
            sb.append("Shards: ").append(shards()).append(",");
        }
        if (hasMoreShards() != null) {
            sb.append("HasMoreShards: ").append(hasMoreShards()).append(",");
        }
        if (retentionPeriodHours() != null) {
            sb.append("RetentionPeriodHours: ").append(retentionPeriodHours()).append(",");
        }
        if (streamCreationTimestamp() != null) {
            sb.append("StreamCreationTimestamp: ").append(streamCreationTimestamp()).append(",");
        }
        if (enhancedMonitoring() != null) {
            sb.append("EnhancedMonitoring: ").append(enhancedMonitoring()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamDescription> {
        /**
         * <p>
         * The name of the stream being described.
         * </p>
         * 
         * @param streamName
         *        The name of the stream being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream being described.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) for the stream being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The current status of the stream being described. The stream status is one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
         * <code>StreamStatus</code> to <code>CREATING</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The stream is being deleted. The specified stream is in the <code>DELETING</code>
         * state until Amazon Kinesis completes the deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You should
         * perform read and write operations only on an <code>ACTIVE</code> stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations continue to
         * work while the stream is in the <code>UPDATING</code> state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamStatus
         *        The current status of the stream being described. The stream status is one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
         *        <code>StreamStatus</code> to <code>CREATING</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The stream is being deleted. The specified stream is in the
         *        <code>DELETING</code> state until Amazon Kinesis completes the deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You
         *        should perform read and write operations only on an <code>ACTIVE</code> stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations
         *        continue to work while the stream is in the <code>UPDATING</code> state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The current status of the stream being described. The stream status is one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
         * <code>StreamStatus</code> to <code>CREATING</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The stream is being deleted. The specified stream is in the <code>DELETING</code>
         * state until Amazon Kinesis completes the deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You should
         * perform read and write operations only on an <code>ACTIVE</code> stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations continue to
         * work while the stream is in the <code>UPDATING</code> state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamStatus
         *        The current status of the stream being described. The stream status is one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The stream is being created. Amazon Kinesis immediately returns and sets
         *        <code>StreamStatus</code> to <code>CREATING</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The stream is being deleted. The specified stream is in the
         *        <code>DELETING</code> state until Amazon Kinesis completes the deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The stream exists and is ready for read and write operations or deletion. You
         *        should perform read and write operations only on an <code>ACTIVE</code> stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Shards in the stream are being merged or split. Read and write operations
         *        continue to work while the stream is in the <code>UPDATING</code> state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(StreamStatus streamStatus);

        /**
         * <p>
         * The shards that comprise the stream.
         * </p>
         * 
         * @param shards
         *        The shards that comprise the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * The shards that comprise the stream.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setShards(java.util.Collection)} or {@link #withShards(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param shards
         *        The shards that comprise the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * If set to <code>true</code>, more shards in the stream are available to describe.
         * </p>
         * 
         * @param hasMoreShards
         *        If set to <code>true</code>, more shards in the stream are available to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreShards(Boolean hasMoreShards);

        /**
         * <p>
         * The current retention period, in hours.
         * </p>
         * 
         * @param retentionPeriodHours
         *        The current retention period, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodHours(Integer retentionPeriodHours);

        /**
         * <p>
         * The approximate time that the stream was created.
         * </p>
         * 
         * @param streamCreationTimestamp
         *        The approximate time that the stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreationTimestamp(Date streamCreationTimestamp);

        /**
         * <p>
         * Represents the current enhanced monitoring settings of the stream.
         * </p>
         * 
         * @param enhancedMonitoring
         *        Represents the current enhanced monitoring settings of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring);

        /**
         * <p>
         * Represents the current enhanced monitoring settings of the stream.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEnhancedMonitoring(java.util.Collection)} or {@link #withEnhancedMonitoring(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param enhancedMonitoring
         *        Represents the current enhanced monitoring settings of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMonitoring(EnhancedMetrics... enhancedMonitoring);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String streamStatus;

        private List<Shard> shards = new SdkInternalList<>();

        private Boolean hasMoreShards;

        private Integer retentionPeriodHours;

        private Date streamCreationTimestamp;

        private List<EnhancedMetrics> enhancedMonitoring = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            setStreamName(model.streamName);
            setStreamARN(model.streamARN);
            setStreamStatus(model.streamStatus);
            setShards(model.shards);
            setHasMoreShards(model.hasMoreShards);
            setRetentionPeriodHours(model.retentionPeriodHours);
            setStreamCreationTimestamp(model.streamCreationTimestamp);
            setEnhancedMonitoring(model.enhancedMonitoring);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final void setStreamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
        }

        public final Collection<Shard> getShards() {
            return shards;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            if (this.shards == null) {
                this.shards = new SdkInternalList<>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
            return this;
        }

        public final void setShards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
        }

        @SafeVarargs
        public final void setShards(Shard... shards) {
            if (this.shards == null) {
                this.shards = new SdkInternalList<>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
        }

        public final Boolean getHasMoreShards() {
            return hasMoreShards;
        }

        @Override
        public final Builder hasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
            return this;
        }

        public final void setHasMoreShards(Boolean hasMoreShards) {
            this.hasMoreShards = hasMoreShards;
        }

        public final Integer getRetentionPeriodHours() {
            return retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        public final Date getStreamCreationTimestamp() {
            return streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Date streamCreationTimestamp) {
            this.streamCreationTimestamp = StandardMemberCopier.copy(streamCreationTimestamp);
            return this;
        }

        public final void setStreamCreationTimestamp(Date streamCreationTimestamp) {
            this.streamCreationTimestamp = StandardMemberCopier.copy(streamCreationTimestamp);
        }

        public final Collection<EnhancedMetrics> getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enhancedMonitoring(EnhancedMetrics... enhancedMonitoring) {
            if (this.enhancedMonitoring == null) {
                this.enhancedMonitoring = new SdkInternalList<>(enhancedMonitoring.length);
            }
            for (EnhancedMetrics e : enhancedMonitoring) {
                this.enhancedMonitoring.add(e);
            }
            return this;
        }

        public final void setEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
            this.enhancedMonitoring = EnhancedMonitoringListCopier.copy(enhancedMonitoring);
        }

        @SafeVarargs
        public final void setEnhancedMonitoring(EnhancedMetrics... enhancedMonitoring) {
            if (this.enhancedMonitoring == null) {
                this.enhancedMonitoring = new SdkInternalList<>(enhancedMonitoring.length);
            }
            for (EnhancedMetrics e : enhancedMonitoring) {
                this.enhancedMonitoring.add(e);
            }
        }

        @Override
        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }
}
