/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.SequenceNumberRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range of possible sequence numbers for the shard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SequenceNumberRange implements StructuredPojo, ToCopyableBuilder<SequenceNumberRange.Builder, SequenceNumberRange> {
    private final String startingSequenceNumber;

    private final String endingSequenceNumber;

    private SequenceNumberRange(BuilderImpl builder) {
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.endingSequenceNumber = builder.endingSequenceNumber;
    }

    /**
     * <p>
     * The starting sequence number for the range.
     * </p>
     * 
     * @return The starting sequence number for the range.
     */
    public String startingSequenceNumber() {
        return startingSequenceNumber;
    }

    /**
     * <p>
     * The ending sequence number for the range. Shards that are in the OPEN state have an ending sequence number of
     * <code>null</code>.
     * </p>
     * 
     * @return The ending sequence number for the range. Shards that are in the OPEN state have an ending sequence
     *         number of <code>null</code>.
     */
    public String endingSequenceNumber() {
        return endingSequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((startingSequenceNumber() == null) ? 0 : startingSequenceNumber().hashCode());
        hashCode = 31 * hashCode + ((endingSequenceNumber() == null) ? 0 : endingSequenceNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceNumberRange)) {
            return false;
        }
        SequenceNumberRange other = (SequenceNumberRange) obj;
        if (other.startingSequenceNumber() == null ^ this.startingSequenceNumber() == null) {
            return false;
        }
        if (other.startingSequenceNumber() != null && !other.startingSequenceNumber().equals(this.startingSequenceNumber())) {
            return false;
        }
        if (other.endingSequenceNumber() == null ^ this.endingSequenceNumber() == null) {
            return false;
        }
        if (other.endingSequenceNumber() != null && !other.endingSequenceNumber().equals(this.endingSequenceNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (startingSequenceNumber() != null) {
            sb.append("StartingSequenceNumber: ").append(startingSequenceNumber()).append(",");
        }
        if (endingSequenceNumber() != null) {
            sb.append("EndingSequenceNumber: ").append(endingSequenceNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SequenceNumberRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SequenceNumberRange> {
        /**
         * <p>
         * The starting sequence number for the range.
         * </p>
         * 
         * @param startingSequenceNumber
         *        The starting sequence number for the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingSequenceNumber(String startingSequenceNumber);

        /**
         * <p>
         * The ending sequence number for the range. Shards that are in the OPEN state have an ending sequence number of
         * <code>null</code>.
         * </p>
         * 
         * @param endingSequenceNumber
         *        The ending sequence number for the range. Shards that are in the OPEN state have an ending sequence
         *        number of <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingSequenceNumber(String endingSequenceNumber);
    }

    private static final class BuilderImpl implements Builder {
        private String startingSequenceNumber;

        private String endingSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceNumberRange model) {
            setStartingSequenceNumber(model.startingSequenceNumber);
            setEndingSequenceNumber(model.endingSequenceNumber);
        }

        public final String getStartingSequenceNumber() {
            return startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final String getEndingSequenceNumber() {
            return endingSequenceNumber;
        }

        @Override
        public final Builder endingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
            return this;
        }

        public final void setEndingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
        }

        @Override
        public SequenceNumberRange build() {
            return new SequenceNumberRange(this);
        }
    }
}
