/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <a>IncreaseStreamRetentionPeriod</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IncreaseStreamRetentionPeriodRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<IncreaseStreamRetentionPeriodRequest.Builder, IncreaseStreamRetentionPeriodRequest> {
    private final String streamName;

    private final Integer retentionPeriodHours;

    private IncreaseStreamRetentionPeriodRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    /**
     * <p>
     * The name of the stream to modify.
     * </p>
     * 
     * @return The name of the stream to modify.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The new retention period of the stream, in hours. Must be more than the current retention period.
     * </p>
     * 
     * @return The new retention period of the stream, in hours. Must be more than the current retention period.
     */
    public Integer retentionPeriodHours() {
        return retentionPeriodHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((retentionPeriodHours() == null) ? 0 : retentionPeriodHours().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseStreamRetentionPeriodRequest)) {
            return false;
        }
        IncreaseStreamRetentionPeriodRequest other = (IncreaseStreamRetentionPeriodRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.retentionPeriodHours() == null ^ this.retentionPeriodHours() == null) {
            return false;
        }
        if (other.retentionPeriodHours() != null && !other.retentionPeriodHours().equals(this.retentionPeriodHours())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (retentionPeriodHours() != null) {
            sb.append("RetentionPeriodHours: ").append(retentionPeriodHours()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IncreaseStreamRetentionPeriodRequest> {
        /**
         * <p>
         * The name of the stream to modify.
         * </p>
         * 
         * @param streamName
         *        The name of the stream to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The new retention period of the stream, in hours. Must be more than the current retention period.
         * </p>
         * 
         * @param retentionPeriodHours
         *        The new retention period of the stream, in hours. Must be more than the current retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodHours(Integer retentionPeriodHours);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseStreamRetentionPeriodRequest model) {
            setStreamName(model.streamName);
            setRetentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getRetentionPeriodHours() {
            return retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public IncreaseStreamRetentionPeriodRequest build() {
            return new IncreaseStreamRetentionPeriodRequest(this);
        }
    }
}
