/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>GetShardIterator</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetShardIteratorRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetShardIteratorRequest.Builder, GetShardIteratorRequest> {
    private final String streamName;

    private final String shardId;

    private final String shardIteratorType;

    private final String startingSequenceNumber;

    private final Date timestamp;

    private GetShardIteratorRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The shard ID of the Amazon Kinesis shard to get the iterator for.
     * </p>
     * 
     * @return The shard ID of the Amazon Kinesis shard to get the iterator for.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * Determines how the shard iterator is used to start reading data records from the shard.
     * </p>
     * <p>
     * The following are the valid Amazon Kinesis shard iterator types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the value
     * <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number, provided in
     * the value <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
     * <code>Timestamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest data
     * record in the shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * LATEST - Start reading just after the most recent record in the shard, so that you always read the most recent
     * data in the shard.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Determines how the shard iterator is used to start reading data records from the shard.</p>
     *         <p>
     *         The following are the valid Amazon Kinesis shard iterator types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in
     *         the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
     *         provided in the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
     *         <code>Timestamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
     *         data record in the shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LATEST - Start reading just after the most recent record in the shard, so that you always read the most
     *         recent data in the shard.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public String shardIteratorType() {
        return shardIteratorType;
    }

    /**
     * <p>
     * The sequence number of the data record in the shard from which to start reading. Used with shard iterator type
     * AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
     * </p>
     * 
     * @return The sequence number of the data record in the shard from which to start reading. Used with shard iterator
     *         type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
     */
    public String startingSequenceNumber() {
        return startingSequenceNumber;
    }

    /**
     * <p>
     * The timestamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A
     * timestamp is the Unix epoch date with precision in milliseconds. For example,
     * <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact timestamp
     * does not exist, the iterator returned is for the next (later) record. If the timestamp is older than the current
     * trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
     * </p>
     * 
     * @return The timestamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP.
     *         A timestamp is the Unix epoch date with precision in milliseconds. For example,
     *         <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact
     *         timestamp does not exist, the iterator returned is for the next (later) record. If the timestamp is older
     *         than the current trim horizon, the iterator returned is for the oldest untrimmed data record
     *         (TRIM_HORIZON).
     */
    public Date timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((shardId() == null) ? 0 : shardId().hashCode());
        hashCode = 31 * hashCode + ((shardIteratorType() == null) ? 0 : shardIteratorType().hashCode());
        hashCode = 31 * hashCode + ((startingSequenceNumber() == null) ? 0 : startingSequenceNumber().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.shardIteratorType() == null ^ this.shardIteratorType() == null) {
            return false;
        }
        if (other.shardIteratorType() != null && !other.shardIteratorType().equals(this.shardIteratorType())) {
            return false;
        }
        if (other.startingSequenceNumber() == null ^ this.startingSequenceNumber() == null) {
            return false;
        }
        if (other.startingSequenceNumber() != null && !other.startingSequenceNumber().equals(this.startingSequenceNumber())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (shardIteratorType() != null) {
            sb.append("ShardIteratorType: ").append(shardIteratorType()).append(",");
        }
        if (startingSequenceNumber() != null) {
            sb.append("StartingSequenceNumber: ").append(startingSequenceNumber()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetShardIteratorRequest> {
        /**
         * <p>
         * The name of the Amazon Kinesis stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The shard ID of the Amazon Kinesis shard to get the iterator for.
         * </p>
         * 
         * @param shardId
         *        The shard ID of the Amazon Kinesis shard to get the iterator for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading data records from the shard.
         * </p>
         * <p>
         * The following are the valid Amazon Kinesis shard iterator types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the
         * value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         * provided in the value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
         * <code>Timestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
         * data record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * LATEST - Start reading just after the most recent record in the shard, so that you always read the most
         * recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading data records from the shard.</p>
         *        <p>
         *        The following are the valid Amazon Kinesis shard iterator types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided
         *        in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         *        provided in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
         *        <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LATEST - Start reading just after the most recent record in the shard, so that you always read the
         *        most recent data in the shard.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(String shardIteratorType);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading data records from the shard.
         * </p>
         * <p>
         * The following are the valid Amazon Kinesis shard iterator types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the
         * value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         * provided in the value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
         * <code>Timestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
         * data record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * LATEST - Start reading just after the most recent record in the shard, so that you always read the most
         * recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading data records from the shard.</p>
         *        <p>
         *        The following are the valid Amazon Kinesis shard iterator types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided
         *        in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         *        provided in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AT_TIMESTAMP - Start reading from the position denoted by a specific timestamp, provided in the value
         *        <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LATEST - Start reading just after the most recent record in the shard, so that you always read the
         *        most recent data in the shard.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(ShardIteratorType shardIteratorType);

        /**
         * <p>
         * The sequence number of the data record in the shard from which to start reading. Used with shard iterator
         * type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
         * </p>
         * 
         * @param startingSequenceNumber
         *        The sequence number of the data record in the shard from which to start reading. Used with shard
         *        iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingSequenceNumber(String startingSequenceNumber);

        /**
         * <p>
         * The timestamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A
         * timestamp is the Unix epoch date with precision in milliseconds. For example,
         * <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact
         * timestamp does not exist, the iterator returned is for the next (later) record. If the timestamp is older
         * than the current trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the data record from which to start reading. Used with shard iterator type
         *        AT_TIMESTAMP. A timestamp is the Unix epoch date with precision in milliseconds. For example,
         *        <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact
         *        timestamp does not exist, the iterator returned is for the next (later) record. If the timestamp is
         *        older than the current trim horizon, the iterator returned is for the oldest untrimmed data record
         *        (TRIM_HORIZON).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Date timestamp);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private String shardId;

        private String shardIteratorType;

        private String startingSequenceNumber;

        private Date timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            setStreamName(model.streamName);
            setShardId(model.shardId);
            setShardIteratorType(model.shardIteratorType);
            setStartingSequenceNumber(model.startingSequenceNumber);
            setTimestamp(model.timestamp);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final void setShardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
        }

        public final String getStartingSequenceNumber() {
            return startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final Date getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy(timestamp);
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }
    }
}
