/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>GetRecords</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRecordsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetRecordsResponse.Builder, GetRecordsResponse> {
    private final List<Record> records;

    private final String nextShardIterator;

    private final Long millisBehindLatest;

    private GetRecordsResponse(BuilderImpl builder) {
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
        this.millisBehindLatest = builder.millisBehindLatest;
    }

    /**
     * <p>
     * The data records retrieved from the shard.
     * </p>
     * 
     * @return The data records retrieved from the shard.
     */
    public List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The next position in the shard from which to start sequentially reading data records. If set to <code>null</code>
     * , the shard has been closed and the requested iterator will not return any more data.
     * </p>
     * 
     * @return The next position in the shard from which to start sequentially reading data records. If set to
     *         <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
     */
    public String nextShardIterator() {
        return nextShardIterator;
    }

    /**
     * <p>
     * The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how far
     * behind current time the consumer is. A value of zero indicates record processing is caught up, and there are no
     * new records to process at this moment.
     * </p>
     * 
     * @return The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how
     *         far behind current time the consumer is. A value of zero indicates record processing is caught up, and
     *         there are no new records to process at this moment.
     */
    public Long millisBehindLatest() {
        return millisBehindLatest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((records() == null) ? 0 : records().hashCode());
        hashCode = 31 * hashCode + ((nextShardIterator() == null) ? 0 : nextShardIterator().hashCode());
        hashCode = 31 * hashCode + ((millisBehindLatest() == null) ? 0 : millisBehindLatest().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse) obj;
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        if (other.nextShardIterator() == null ^ this.nextShardIterator() == null) {
            return false;
        }
        if (other.nextShardIterator() != null && !other.nextShardIterator().equals(this.nextShardIterator())) {
            return false;
        }
        if (other.millisBehindLatest() == null ^ this.millisBehindLatest() == null) {
            return false;
        }
        if (other.millisBehindLatest() != null && !other.millisBehindLatest().equals(this.millisBehindLatest())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (records() != null) {
            sb.append("Records: ").append(records()).append(",");
        }
        if (nextShardIterator() != null) {
            sb.append("NextShardIterator: ").append(nextShardIterator()).append(",");
        }
        if (millisBehindLatest() != null) {
            sb.append("MillisBehindLatest: ").append(millisBehindLatest()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetRecordsResponse> {
        /**
         * <p>
         * The data records retrieved from the shard.
         * </p>
         * 
         * @param records
         *        The data records retrieved from the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The data records retrieved from the shard.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRecords(java.util.Collection)} or {@link #withRecords(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param records
         *        The data records retrieved from the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The next position in the shard from which to start sequentially reading data records. If set to
         * <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
         * </p>
         * 
         * @param nextShardIterator
         *        The next position in the shard from which to start sequentially reading data records. If set to
         *        <code>null</code>, the shard has been closed and the requested iterator will not return any more data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextShardIterator(String nextShardIterator);

        /**
         * <p>
         * The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating how far
         * behind current time the consumer is. A value of zero indicates record processing is caught up, and there are
         * no new records to process at this moment.
         * </p>
         * 
         * @param millisBehindLatest
         *        The number of milliseconds the <a>GetRecords</a> response is from the tip of the stream, indicating
         *        how far behind current time the consumer is. A value of zero indicates record processing is caught up,
         *        and there are no new records to process at this moment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisBehindLatest(Long millisBehindLatest);
    }

    private static final class BuilderImpl implements Builder {
        private List<Record> records = new SdkInternalList<>();

        private String nextShardIterator;

        private Long millisBehindLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            setRecords(model.records);
            setNextShardIterator(model.nextShardIterator);
            setMillisBehindLatest(model.millisBehindLatest);
        }

        public final Collection<Record> getRecords() {
            return records;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            if (this.records == null) {
                this.records = new SdkInternalList<>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(Record... records) {
            if (this.records == null) {
                this.records = new SdkInternalList<>(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
        }

        public final String getNextShardIterator() {
            return nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        public final Long getMillisBehindLatest() {
            return millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }
}
