/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a destination in Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftDestinationDescription implements StructuredPojo,
        ToCopyableBuilder<RedshiftDestinationDescription.Builder, RedshiftDestinationDescription> {
    private final String roleARN;

    private final String clusterJDBCURL;

    private final CopyCommand copyCommand;

    private final String username;

    private final RedshiftRetryOptions retryOptions;

    private final S3DestinationDescription s3DestinationDescription;

    private final ProcessingConfiguration processingConfiguration;

    private final String s3BackupMode;

    private final S3DestinationDescription s3BackupDescription;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.retryOptions = builder.retryOptions;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The database connection string.
     * </p>
     * 
     * @return The database connection string.
     */
    public String clusterJDBCURL() {
        return clusterJDBCURL;
    }

    /**
     * <p>
     * The <code>COPY</code> command.
     * </p>
     * 
     * @return The <code>COPY</code> command.
     */
    public CopyCommand copyCommand() {
        return copyCommand;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The retry behavior in the event that Firehose is unable to deliver documents to Amazon Redshift. Default value is
     * 3600 (60 minutes).
     * </p>
     * 
     * @return The retry behavior in the event that Firehose is unable to deliver documents to Amazon Redshift. Default
     *         value is 3600 (60 minutes).
     */
    public RedshiftRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * 
     * @return The Amazon S3 destination.
     */
    public S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see RedshiftS3BackupMode
     */
    public String s3BackupMode() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The configuration for backup in Amazon S3.
     * </p>
     * 
     * @return The configuration for backup in Amazon S3.
     */
    public S3DestinationDescription s3BackupDescription() {
        return s3BackupDescription;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((clusterJDBCURL() == null) ? 0 : clusterJDBCURL().hashCode());
        hashCode = 31 * hashCode + ((copyCommand() == null) ? 0 : copyCommand().hashCode());
        hashCode = 31 * hashCode + ((username() == null) ? 0 : username().hashCode());
        hashCode = 31 * hashCode + ((retryOptions() == null) ? 0 : retryOptions().hashCode());
        hashCode = 31 * hashCode + ((s3DestinationDescription() == null) ? 0 : s3DestinationDescription().hashCode());
        hashCode = 31 * hashCode + ((processingConfiguration() == null) ? 0 : processingConfiguration().hashCode());
        hashCode = 31 * hashCode + ((s3BackupMode() == null) ? 0 : s3BackupMode().hashCode());
        hashCode = 31 * hashCode + ((s3BackupDescription() == null) ? 0 : s3BackupDescription().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptions() == null) ? 0 : cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationDescription)) {
            return false;
        }
        RedshiftDestinationDescription other = (RedshiftDestinationDescription) obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clusterJDBCURL() == null ^ this.clusterJDBCURL() == null) {
            return false;
        }
        if (other.clusterJDBCURL() != null && !other.clusterJDBCURL().equals(this.clusterJDBCURL())) {
            return false;
        }
        if (other.copyCommand() == null ^ this.copyCommand() == null) {
            return false;
        }
        if (other.copyCommand() != null && !other.copyCommand().equals(this.copyCommand())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3DestinationDescription() == null ^ this.s3DestinationDescription() == null) {
            return false;
        }
        if (other.s3DestinationDescription() != null && !other.s3DestinationDescription().equals(this.s3DestinationDescription())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.s3BackupMode() == null ^ this.s3BackupMode() == null) {
            return false;
        }
        if (other.s3BackupMode() != null && !other.s3BackupMode().equals(this.s3BackupMode())) {
            return false;
        }
        if (other.s3BackupDescription() == null ^ this.s3BackupDescription() == null) {
            return false;
        }
        if (other.s3BackupDescription() != null && !other.s3BackupDescription().equals(this.s3BackupDescription())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (clusterJDBCURL() != null) {
            sb.append("ClusterJDBCURL: ").append(clusterJDBCURL()).append(",");
        }
        if (copyCommand() != null) {
            sb.append("CopyCommand: ").append(copyCommand()).append(",");
        }
        if (username() != null) {
            sb.append("Username: ").append(username()).append(",");
        }
        if (retryOptions() != null) {
            sb.append("RetryOptions: ").append(retryOptions()).append(",");
        }
        if (s3DestinationDescription() != null) {
            sb.append("S3DestinationDescription: ").append(s3DestinationDescription()).append(",");
        }
        if (processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(processingConfiguration()).append(",");
        }
        if (s3BackupMode() != null) {
            sb.append("S3BackupMode: ").append(s3BackupMode()).append(",");
        }
        if (s3BackupDescription() != null) {
            sb.append("S3BackupDescription: ").append(s3BackupDescription()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftDestinationDescription> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The database connection string.
         * </p>
         * 
         * @param clusterJDBCURL
         *        The database connection string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterJDBCURL(String clusterJDBCURL);

        /**
         * <p>
         * The <code>COPY</code> command.
         * </p>
         * 
         * @param copyCommand
         *        The <code>COPY</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyCommand(CopyCommand copyCommand);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The retry behavior in the event that Firehose is unable to deliver documents to Amazon Redshift. Default
         * value is 3600 (60 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in the event that Firehose is unable to deliver documents to Amazon Redshift.
         *        Default value is 3600 (60 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(RedshiftRetryOptions retryOptions);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * 
         * @param s3DestinationDescription
         *        The Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode);

        /**
         * <p>
         * The configuration for backup in Amazon S3.
         * </p>
         * 
         * @param s3BackupDescription
         *        The configuration for backup in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BackupDescription(S3DestinationDescription s3BackupDescription);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);
    }

    private static final class BuilderImpl implements Builder {
        private String roleARN;

        private String clusterJDBCURL;

        private CopyCommand copyCommand;

        private String username;

        private RedshiftRetryOptions retryOptions;

        private S3DestinationDescription s3DestinationDescription;

        private ProcessingConfiguration processingConfiguration;

        private String s3BackupMode;

        private S3DestinationDescription s3BackupDescription;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationDescription model) {
            setRoleARN(model.roleARN);
            setClusterJDBCURL(model.clusterJDBCURL);
            setCopyCommand(model.copyCommand);
            setUsername(model.username);
            setRetryOptions(model.retryOptions);
            setS3DestinationDescription(model.s3DestinationDescription);
            setProcessingConfiguration(model.processingConfiguration);
            setS3BackupMode(model.s3BackupMode);
            setS3BackupDescription(model.s3BackupDescription);
            setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand getCopyCommand() {
            return copyCommand;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final RedshiftRetryOptions getRetryOptions() {
            return retryOptions;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
        }

        public final S3DestinationDescription getS3DestinationDescription() {
            return s3DestinationDescription;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final void setS3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
        }

        public final S3DestinationDescription getS3BackupDescription() {
            return s3BackupDescription;
        }

        @Override
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final void setS3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        @Override
        public RedshiftDestinationDescription build() {
            return new RedshiftDestinationDescription(this);
        }
    }
}
