/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the encryption for a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EncryptionConfiguration implements StructuredPojo,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private final String noEncryptionConfig;

    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    /**
     * <p>
     * Specifically override existing encryption information to ensure no encryption is used.
     * </p>
     * 
     * @return Specifically override existing encryption information to ensure no encryption is used.
     * @see NoEncryptionConfig
     */
    public String noEncryptionConfig() {
        return noEncryptionConfig;
    }

    /**
     * <p>
     * The encryption key.
     * </p>
     * 
     * @return The encryption key.
     */
    public KMSEncryptionConfig kmsEncryptionConfig() {
        return kmsEncryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((noEncryptionConfig() == null) ? 0 : noEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + ((kmsEncryptionConfig() == null) ? 0 : kmsEncryptionConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        if (other.noEncryptionConfig() == null ^ this.noEncryptionConfig() == null) {
            return false;
        }
        if (other.noEncryptionConfig() != null && !other.noEncryptionConfig().equals(this.noEncryptionConfig())) {
            return false;
        }
        if (other.kmsEncryptionConfig() == null ^ this.kmsEncryptionConfig() == null) {
            return false;
        }
        if (other.kmsEncryptionConfig() != null && !other.kmsEncryptionConfig().equals(this.kmsEncryptionConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (noEncryptionConfig() != null) {
            sb.append("NoEncryptionConfig: ").append(noEncryptionConfig()).append(",");
        }
        if (kmsEncryptionConfig() != null) {
            sb.append("KMSEncryptionConfig: ").append(kmsEncryptionConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * Specifically override existing encryption information to ensure no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure no encryption is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(String noEncryptionConfig);

        /**
         * <p>
         * Specifically override existing encryption information to ensure no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure no encryption is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig);

        /**
         * <p>
         * The encryption key.
         * </p>
         * 
         * @param kmsEncryptionConfig
         *        The encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig);
    }

    private static final class BuilderImpl implements Builder {
        private String noEncryptionConfig;

        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            setNoEncryptionConfig(model.noEncryptionConfig);
            setKMSEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return noEncryptionConfig;
        }

        @Override
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
            return this;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        public final void setNoEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
        }

        public final KMSEncryptionConfig getKMSEncryptionConfig() {
            return kmsEncryptionConfig;
        }

        @Override
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        public final void setKMSEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }
}
