/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDeliveryStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteDeliveryStreamRequest.Builder, DeleteDeliveryStreamRequest> {
    private final String deliveryStreamName;

    private DeleteDeliveryStreamRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeliveryStreamRequest)) {
            return false;
        }
        DeleteDeliveryStreamRequest other = (DeleteDeliveryStreamRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);
    }

    private static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeliveryStreamRequest model) {
            setDeliveryStreamName(model.deliveryStreamName);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public DeleteDeliveryStreamRequest build() {
            return new DeleteDeliveryStreamRequest(this);
        }
    }
}
