/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary;

public class ListWorkerConfigurationsIterable
implements SdkIterable<ListWorkerConfigurationsResponse> {
    private final KafkaConnectClient client;
    private final ListWorkerConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkerConfigurationsIterable(KafkaConnectClient client, ListWorkerConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkerConfigurationsResponseFetcher();
    }

    public Iterator<ListWorkerConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkerConfigurationSummary> workerConfigurations() {
        Function<ListWorkerConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workerConfigurations() != null) {
                return response.workerConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkerConfigurationsResponseFetcher
    implements SyncPageFetcher<ListWorkerConfigurationsResponse> {
        private ListWorkerConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkerConfigurationsResponse nextPage(ListWorkerConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerConfigurationsIterable.this.client.listWorkerConfigurations(ListWorkerConfigurationsIterable.this.firstRequest);
            }
            return ListWorkerConfigurationsIterable.this.client.listWorkerConfigurations((ListWorkerConfigurationsRequest)((Object)ListWorkerConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

