/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse;

public class ListStorageConfigurationsIterable
implements SdkIterable<ListStorageConfigurationsResponse> {
    private final IvsRealTimeClient client;
    private final ListStorageConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageConfigurationsIterable(IvsRealTimeClient client, ListStorageConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStorageConfigurationsResponseFetcher();
    }

    public Iterator<ListStorageConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStorageConfigurationsResponseFetcher
    implements SyncPageFetcher<ListStorageConfigurationsResponse> {
        private ListStorageConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageConfigurationsResponse nextPage(ListStorageConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageConfigurationsIterable.this.client.listStorageConfigurations(ListStorageConfigurationsIterable.this.firstRequest);
            }
            return ListStorageConfigurationsIterable.this.client.listStorageConfigurations((ListStorageConfigurationsRequest)((Object)ListStorageConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

