/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivschat.model.IvschatResponse;
import software.amazon.awssdk.services.ivschat.model.RoomListCopier;
import software.amazon.awssdk.services.ivschat.model.RoomSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoomsResponse
extends IvschatResponse
implements ToCopyableBuilder<Builder, ListRoomsResponse> {
    private static final SdkField<List<RoomSummary>> ROOMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rooms").getter(ListRoomsResponse.getter(ListRoomsResponse::rooms)).setter(ListRoomsResponse.setter(Builder::rooms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rooms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoomSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRoomsResponse.getter(ListRoomsResponse::nextToken)).setter(ListRoomsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRoomsResponse.memberNameToFieldInitializer();
    private final List<RoomSummary> rooms;
    private final String nextToken;

    private ListRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRooms() {
        return this.rooms != null && !(this.rooms instanceof SdkAutoConstructList);
    }

    public final List<RoomSummary> rooms() {
        return this.rooms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRooms() ? this.rooms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsResponse)) {
            return false;
        }
        ListRoomsResponse other = (ListRoomsResponse)((Object)obj);
        return this.hasRooms() == other.hasRooms() && Objects.equals(this.rooms(), other.rooms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoomsResponse").add("Rooms", this.hasRooms() ? this.rooms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rooms": {
                return Optional.ofNullable(clazz.cast(this.rooms()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rooms", ROOMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoomsResponse, T> g) {
        return obj -> g.apply((ListRoomsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatResponse.BuilderImpl
    implements Builder {
        private List<RoomSummary> rooms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomsResponse model) {
            super(model);
            this.rooms(model.rooms);
            this.nextToken(model.nextToken);
        }

        public final List<RoomSummary.Builder> getRooms() {
            List<RoomSummary.Builder> result = RoomListCopier.copyToBuilder(this.rooms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRooms(Collection<RoomSummary.BuilderImpl> rooms) {
            this.rooms = RoomListCopier.copyFromBuilder(rooms);
        }

        @Override
        public final Builder rooms(Collection<RoomSummary> rooms) {
            this.rooms = RoomListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomSummary ... rooms) {
            this.rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<RoomSummary.Builder> ... rooms) {
            this.rooms(Stream.of(rooms).map(c -> (RoomSummary)((RoomSummary.Builder)RoomSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoomsResponse build() {
            return new ListRoomsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvschatResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoomsResponse> {
        public Builder rooms(Collection<RoomSummary> var1);

        public Builder rooms(RoomSummary ... var1);

        public Builder rooms(Consumer<RoomSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

