/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivschat.model.IvschatResponse;
import software.amazon.awssdk.services.ivschat.model.LoggingConfigurationListCopier;
import software.amazon.awssdk.services.ivschat.model.LoggingConfigurationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLoggingConfigurationsResponse
extends IvschatResponse
implements ToCopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
    private static final SdkField<List<LoggingConfigurationSummary>> LOGGING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loggingConfigurations").getter(ListLoggingConfigurationsResponse.getter(ListLoggingConfigurationsResponse::loggingConfigurations)).setter(ListLoggingConfigurationsResponse.setter(Builder::loggingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoggingConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLoggingConfigurationsResponse.getter(ListLoggingConfigurationsResponse::nextToken)).setter(ListLoggingConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLoggingConfigurationsResponse.memberNameToFieldInitializer();
    private final List<LoggingConfigurationSummary> loggingConfigurations;
    private final String nextToken;

    private ListLoggingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfigurations = builder.loggingConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLoggingConfigurations() {
        return this.loggingConfigurations != null && !(this.loggingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LoggingConfigurationSummary> loggingConfigurations() {
        return this.loggingConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurations() ? this.loggingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoggingConfigurationsResponse)) {
            return false;
        }
        ListLoggingConfigurationsResponse other = (ListLoggingConfigurationsResponse)((Object)obj);
        return this.hasLoggingConfigurations() == other.hasLoggingConfigurations() && Objects.equals(this.loggingConfigurations(), other.loggingConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLoggingConfigurationsResponse").add("LoggingConfigurations", this.hasLoggingConfigurations() ? this.loggingConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loggingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loggingConfigurations", LOGGING_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLoggingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListLoggingConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatResponse.BuilderImpl
    implements Builder {
        private List<LoggingConfigurationSummary> loggingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoggingConfigurationsResponse model) {
            super(model);
            this.loggingConfigurations(model.loggingConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<LoggingConfigurationSummary.Builder> getLoggingConfigurations() {
            List<LoggingConfigurationSummary.Builder> result = LoggingConfigurationListCopier.copyToBuilder(this.loggingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoggingConfigurations(Collection<LoggingConfigurationSummary.BuilderImpl> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationListCopier.copyFromBuilder(loggingConfigurations);
        }

        @Override
        public final Builder loggingConfigurations(Collection<LoggingConfigurationSummary> loggingConfigurations) {
            this.loggingConfigurations = LoggingConfigurationListCopier.copy(loggingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(LoggingConfigurationSummary ... loggingConfigurations) {
            this.loggingConfigurations(Arrays.asList(loggingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(Consumer<LoggingConfigurationSummary.Builder> ... loggingConfigurations) {
            this.loggingConfigurations(Stream.of(loggingConfigurations).map(c -> (LoggingConfigurationSummary)((LoggingConfigurationSummary.Builder)LoggingConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLoggingConfigurationsResponse build() {
            return new ListLoggingConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvschatResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLoggingConfigurationsResponse> {
        public Builder loggingConfigurations(Collection<LoggingConfigurationSummary> var1);

        public Builder loggingConfigurations(LoggingConfigurationSummary ... var1);

        public Builder loggingConfigurations(Consumer<LoggingConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

