/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChatTokenRequest extends IvschatRequest implements
        ToCopyableBuilder<CreateChatTokenRequest.Builder, CreateChatTokenRequest> {
    private static final SdkField<String> ROOM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roomIdentifier").getter(getter(CreateChatTokenRequest::roomIdentifier))
            .setter(setter(Builder::roomIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roomIdentifier").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(CreateChatTokenRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CreateChatTokenRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SESSION_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("sessionDurationInMinutes")
            .getter(getter(CreateChatTokenRequest::sessionDurationInMinutes)).setter(setter(Builder::sessionDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionDurationInMinutes").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(CreateChatTokenRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_IDENTIFIER_FIELD,
            USER_ID_FIELD, CAPABILITIES_FIELD, SESSION_DURATION_IN_MINUTES_FIELD, ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String roomIdentifier;

    private final String userId;

    private final List<String> capabilities;

    private final Integer sessionDurationInMinutes;

    private final Map<String, String> attributes;

    private CreateChatTokenRequest(BuilderImpl builder) {
        super(builder);
        this.roomIdentifier = builder.roomIdentifier;
        this.userId = builder.userId;
        this.capabilities = builder.capabilities;
        this.sessionDurationInMinutes = builder.sessionDurationInMinutes;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * Identifier of the room that the client is trying to access. Currently this must be an ARN.
     * </p>
     * 
     * @return Identifier of the room that the client is trying to access. Currently this must be an ARN.
     */
    public final String roomIdentifier() {
        return roomIdentifier;
    }

    /**
     * <p>
     * Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8
     * encoded text.
     * </p>
     * 
     * @return Application-provided ID that uniquely identifies the user associated with this token. This can be any
     *         UTF-8 encoded text.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
     * messages is implicitly included in all requests).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
     *         view messages is implicitly included in all requests).
     */
    public final List<ChatTokenCapability> capabilities() {
        return ChatTokenCapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
     * messages is implicitly included in all requests).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
     *         view messages is implicitly included in all requests).
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
     * </p>
     * 
     * @return Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
     */
    public final Integer sessionDurationInMinutes() {
        return sessionDurationInMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can
     * contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to encode into the token and attach to a chat session. Map keys and
     *         values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roomIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatTokenRequest)) {
            return false;
        }
        CreateChatTokenRequest other = (CreateChatTokenRequest) obj;
        return Objects.equals(roomIdentifier(), other.roomIdentifier()) && Objects.equals(userId(), other.userId())
                && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(sessionDurationInMinutes(), other.sessionDurationInMinutes())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChatTokenRequest").add("RoomIdentifier", roomIdentifier())
                .add("UserId", userId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("SessionDurationInMinutes", sessionDurationInMinutes())
                .add("Attributes", attributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roomIdentifier":
            return Optional.ofNullable(clazz.cast(roomIdentifier()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "sessionDurationInMinutes":
            return Optional.ofNullable(clazz.cast(sessionDurationInMinutes()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roomIdentifier", ROOM_IDENTIFIER_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("sessionDurationInMinutes", SESSION_DURATION_IN_MINUTES_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChatTokenRequest, T> g) {
        return obj -> g.apply((CreateChatTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvschatRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChatTokenRequest> {
        /**
         * <p>
         * Identifier of the room that the client is trying to access. Currently this must be an ARN.
         * </p>
         * 
         * @param roomIdentifier
         *        Identifier of the room that the client is trying to access. Currently this must be an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomIdentifier(String roomIdentifier);

        /**
         * <p>
         * Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8
         * encoded text.
         * </p>
         * 
         * @param userId
         *        Application-provided ID that uniquely identifies the user associated with this token. This can be any
         *        UTF-8 encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
         * messages is implicitly included in all requests).
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
         *        view messages is implicitly included in all requests).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
         * messages is implicitly included in all requests).
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
         *        view messages is implicitly included in all requests).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
         * messages is implicitly included in all requests).
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
         *        view messages is implicitly included in all requests).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<ChatTokenCapability> capabilities);

        /**
         * <p>
         * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view
         * messages is implicitly included in all requests).
         * </p>
         * 
         * @param capabilities
         *        Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to
         *        view messages is implicitly included in all requests).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(ChatTokenCapability... capabilities);

        /**
         * <p>
         * Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
         * </p>
         * 
         * @param sessionDurationInMinutes
         *        Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionDurationInMinutes(Integer sessionDurationInMinutes);

        /**
         * <p>
         * Application-provided attributes to encode into the token and attach to a chat session. Map keys and values
         * can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to encode into the token and attach to a chat session. Map keys and
         *        values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvschatRequest.BuilderImpl implements Builder {
        private String roomIdentifier;

        private String userId;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private Integer sessionDurationInMinutes;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChatTokenRequest model) {
            super(model);
            roomIdentifier(model.roomIdentifier);
            userId(model.userId);
            capabilitiesWithStrings(model.capabilities);
            sessionDurationInMinutes(model.sessionDurationInMinutes);
            attributes(model.attributes);
        }

        public final String getRoomIdentifier() {
            return roomIdentifier;
        }

        public final void setRoomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
        }

        @Override
        public final Builder roomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<ChatTokenCapability> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(ChatTokenCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Integer getSessionDurationInMinutes() {
            return sessionDurationInMinutes;
        }

        public final void setSessionDurationInMinutes(Integer sessionDurationInMinutes) {
            this.sessionDurationInMinutes = sessionDurationInMinutes;
        }

        @Override
        public final Builder sessionDurationInMinutes(Integer sessionDurationInMinutes) {
            this.sessionDurationInMinutes = sessionDurationInMinutes;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ChatTokenAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ChatTokenAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChatTokenRequest build() {
            return new CreateChatTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
