/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivschat.IvschatClient;
import software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse;

public class ListLoggingConfigurationsIterable
implements SdkIterable<ListLoggingConfigurationsResponse> {
    private final IvschatClient client;
    private final ListLoggingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLoggingConfigurationsIterable(IvschatClient client, ListLoggingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLoggingConfigurationsResponseFetcher();
    }

    public Iterator<ListLoggingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLoggingConfigurationsResponseFetcher
    implements SyncPageFetcher<ListLoggingConfigurationsResponse> {
        private ListLoggingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLoggingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLoggingConfigurationsResponse nextPage(ListLoggingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListLoggingConfigurationsIterable.this.client.listLoggingConfigurations(ListLoggingConfigurationsIterable.this.firstRequest);
            }
            return ListLoggingConfigurationsIterable.this.client.listLoggingConfigurations((ListLoggingConfigurationsRequest)((Object)ListLoggingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

