/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FallbackResult {
    ALLOW("ALLOW"),
    DENY("DENY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FallbackResult> VALUE_MAP;
    private final String value;

    private FallbackResult(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FallbackResult fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FallbackResult> knownValues() {
        EnumSet<FallbackResult> knownValues = EnumSet.allOf(FallbackResult.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FallbackResult.class, FallbackResult::toString);
    }
}

