/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse;

public class ListMetadataTransferJobsPublisher
implements SdkPublisher<ListMetadataTransferJobsResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListMetadataTransferJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetadataTransferJobsPublisher(IoTTwinMakerAsyncClient client, ListMetadataTransferJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetadataTransferJobsPublisher(IoTTwinMakerAsyncClient client, ListMetadataTransferJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetadataTransferJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetadataTransferJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMetadataTransferJobsResponseFetcher
    implements AsyncPageFetcher<ListMetadataTransferJobsResponse> {
        private ListMetadataTransferJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetadataTransferJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetadataTransferJobsResponse> nextPage(ListMetadataTransferJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMetadataTransferJobsPublisher.this.client.listMetadataTransferJobs(ListMetadataTransferJobsPublisher.this.firstRequest);
            }
            return ListMetadataTransferJobsPublisher.this.client.listMetadataTransferJobs((ListMetadataTransferJobsRequest)((Object)ListMetadataTransferJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

