/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.GeneratedSceneMetadataMapCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SceneCapabilitiesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SceneError;
import software.amazon.awssdk.services.iottwinmaker.model.SceneMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSceneResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetSceneResponse> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetSceneResponse.getter(GetSceneResponse::workspaceId)).setter(GetSceneResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sceneId").getter(GetSceneResponse.getter(GetSceneResponse::sceneId)).setter(GetSceneResponse.setter(Builder::sceneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()}).build();
    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentLocation").getter(GetSceneResponse.getter(GetSceneResponse::contentLocation)).setter(GetSceneResponse.setter(Builder::contentLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSceneResponse.getter(GetSceneResponse::arn)).setter(GetSceneResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetSceneResponse.getter(GetSceneResponse::creationDateTime)).setter(GetSceneResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetSceneResponse.getter(GetSceneResponse::updateDateTime)).setter(GetSceneResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSceneResponse.getter(GetSceneResponse::description)).setter(GetSceneResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(GetSceneResponse.getter(GetSceneResponse::capabilities)).setter(GetSceneResponse.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SCENE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sceneMetadata").getter(GetSceneResponse.getter(GetSceneResponse::sceneMetadata)).setter(GetSceneResponse.setter(Builder::sceneMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> GENERATED_SCENE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("generatedSceneMetadata").getter(GetSceneResponse.getter(GetSceneResponse::generatedSceneMetadata)).setter(GetSceneResponse.setter(Builder::generatedSceneMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedSceneMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SceneError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetSceneResponse.getter(GetSceneResponse::error)).setter(GetSceneResponse.setter(Builder::error)).constructor(SceneError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, SCENE_ID_FIELD, CONTENT_LOCATION_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, SCENE_METADATA_FIELD, GENERATED_SCENE_METADATA_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("workspaceId", WORKSPACE_ID_FIELD);
            this.put("sceneId", SCENE_ID_FIELD);
            this.put("contentLocation", CONTENT_LOCATION_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("capabilities", CAPABILITIES_FIELD);
            this.put("sceneMetadata", SCENE_METADATA_FIELD);
            this.put("generatedSceneMetadata", GENERATED_SCENE_METADATA_FIELD);
            this.put("error", ERROR_FIELD);
        }
    });
    private final String workspaceId;
    private final String sceneId;
    private final String contentLocation;
    private final String arn;
    private final Instant creationDateTime;
    private final Instant updateDateTime;
    private final String description;
    private final List<String> capabilities;
    private final Map<String, String> sceneMetadata;
    private final Map<String, String> generatedSceneMetadata;
    private final SceneError error;

    private GetSceneResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.sceneMetadata = builder.sceneMetadata;
        this.generatedSceneMetadata = builder.generatedSceneMetadata;
        this.error = builder.error;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String sceneId() {
        return this.sceneId;
    }

    public final String contentLocation() {
        return this.contentLocation;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final boolean hasSceneMetadata() {
        return this.sceneMetadata != null && !(this.sceneMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sceneMetadata() {
        return this.sceneMetadata;
    }

    public final boolean hasGeneratedSceneMetadata() {
        return this.generatedSceneMetadata != null && !(this.generatedSceneMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> generatedSceneMetadata() {
        return this.generatedSceneMetadata;
    }

    public final SceneError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSceneMetadata() ? this.sceneMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedSceneMetadata() ? this.generatedSceneMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSceneResponse)) {
            return false;
        }
        GetSceneResponse other = (GetSceneResponse)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.sceneId(), other.sceneId()) && Objects.equals(this.contentLocation(), other.contentLocation()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.description(), other.description()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && this.hasSceneMetadata() == other.hasSceneMetadata() && Objects.equals(this.sceneMetadata(), other.sceneMetadata()) && this.hasGeneratedSceneMetadata() == other.hasGeneratedSceneMetadata() && Objects.equals(this.generatedSceneMetadata(), other.generatedSceneMetadata()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"GetSceneResponse").add("WorkspaceId", (Object)this.workspaceId()).add("SceneId", (Object)this.sceneId()).add("ContentLocation", (Object)this.contentLocation()).add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).add("Description", (Object)this.description()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("SceneMetadata", this.hasSceneMetadata() ? this.sceneMetadata() : null).add("GeneratedSceneMetadata", this.hasGeneratedSceneMetadata() ? this.generatedSceneMetadata() : null).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "sceneId": {
                return Optional.ofNullable(clazz.cast(this.sceneId()));
            }
            case "contentLocation": {
                return Optional.ofNullable(clazz.cast(this.contentLocation()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "sceneMetadata": {
                return Optional.ofNullable(clazz.cast(this.sceneMetadata()));
            }
            case "generatedSceneMetadata": {
                return Optional.ofNullable(clazz.cast(this.generatedSceneMetadata()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSceneResponse, T> g) {
        return obj -> g.apply((GetSceneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String sceneId;
        private String contentLocation;
        private String arn;
        private Instant creationDateTime;
        private Instant updateDateTime;
        private String description;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sceneMetadata = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> generatedSceneMetadata = DefaultSdkAutoConstructMap.getInstance();
        private SceneError error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSceneResponse model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.sceneId(model.sceneId);
            this.contentLocation(model.contentLocation);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
            this.description(model.description);
            this.capabilities(model.capabilities);
            this.sceneMetadata(model.sceneMetadata);
            this.generatedSceneMetadata(model.generatedSceneMetadata);
            this.error(model.error);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSceneId() {
            return this.sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return this.contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Map<String, String> getSceneMetadata() {
            if (this.sceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sceneMetadata;
        }

        public final void setSceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
        }

        @Override
        public final Builder sceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
            return this;
        }

        public final Map<String, String> getGeneratedSceneMetadata() {
            if (this.generatedSceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.generatedSceneMetadata;
        }

        public final void setGeneratedSceneMetadata(Map<String, String> generatedSceneMetadata) {
            this.generatedSceneMetadata = GeneratedSceneMetadataMapCopier.copy(generatedSceneMetadata);
        }

        @Override
        public final Builder generatedSceneMetadata(Map<String, String> generatedSceneMetadata) {
            this.generatedSceneMetadata = GeneratedSceneMetadataMapCopier.copy(generatedSceneMetadata);
            return this;
        }

        public final SceneError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(SceneError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(SceneError error) {
            this.error = error;
            return this;
        }

        @Override
        public GetSceneResponse build() {
            return new GetSceneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSceneResponse> {
        public Builder workspaceId(String var1);

        public Builder sceneId(String var1);

        public Builder contentLocation(String var1);

        public Builder arn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder sceneMetadata(Map<String, String> var1);

        public Builder generatedSceneMetadata(Map<String, String> var1);

        public Builder error(SceneError var1);

        default public Builder error(Consumer<SceneError.Builder> error) {
            return this.error((SceneError)((SceneError.Builder)SceneError.builder().applyMutation(error)).build());
        }
    }
}

